/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ThreadReference;

public class StackFrameReference {
    private final int depth;
    private final int hash;
    private final ThreadReference thread;
    private Types.Source source;

    public StackFrameReference(ThreadReference thread, int depth) {
        if (thread == null) {
            throw new NullPointerException("'thread' should not be null for StackFrameReference");
        }
        if (depth < 0) {
            throw new IllegalArgumentException("'depth' should not be zero or an positive integer.");
        }
        this.thread = thread;
        this.depth = depth;
        this.hash = Long.hashCode(thread.hashCode()) + depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public ThreadReference getThread() {
        return this.thread;
    }

    public Types.Source getSource() {
        return this.source;
    }

    public void setSource(Types.Source source) {
        this.source = source;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        StackFrameReference sf = (StackFrameReference)obj;
        return this.thread.equals(sf.thread) && this.depth == sf.depth;
    }
}

