/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;

public class JsonUtils {
    private static final Gson GSON = new Gson();

    public static <T> T fromJson(String json, Class<T> classOfT) throws JsonSyntaxException {
        return (T)GSON.fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Type typeOfT) throws JsonSyntaxException {
        return (T)GSON.fromJson(json, typeOfT);
    }

    public static <T> T fromJson(JsonElement json, Class<T> classOfT) throws JsonSyntaxException {
        return (T)GSON.fromJson(json, classOfT);
    }

    public <T> T fromJson(JsonElement json, Type typeOfT) throws JsonSyntaxException {
        return (T)GSON.fromJson(json, typeOfT);
    }

    public static String toJson(Object src) {
        return GSON.toJson(src);
    }

    public static String toJson(Object src, Type typeOfSrc) {
        return GSON.toJson(src, typeOfSrc);
    }

    public static JsonElement toJsonTree(Object src, Type typeOfSrc) {
        return GSON.toJsonTree(src, typeOfSrc);
    }

    public static int getInt(JsonObject args, String property, int defaultValue) {
        try {
            return args.getAsInt();
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static String getString(JsonObject args, String property, String defaultValue) {
        String value = null;
        try {
            JsonElement obj = args.get(property);
            value = obj.getAsString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public static boolean getBoolean(JsonObject args, String property, boolean defaultValue) {
        try {
            JsonElement obj = args.get(property);
            return obj.getAsBoolean();
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static String[] getStringArray(JsonElement args, String property) {
        if (args instanceof JsonArray) {
            JsonArray array = (JsonArray)args;
            int size = array.size();
            String[] result = new String[size];
            for (int i = 0; i < size; ++i) {
                result[i] = array.get(i).getAsString();
            }
            return result;
        }
        return new String[0];
    }
}

