/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.protocol.Types;
import java.util.Objects;

public class JavaBreakpointLocation {
    private int lineNumberInSourceFile = Integer.MIN_VALUE;
    private int lineNumber;
    private int columnNumber = -1;
    private String className;
    private String methodName;
    private String methodSignature;
    private Types.BreakpointLocation[] availableBreakpointLocations = new Types.BreakpointLocation[0];

    public JavaBreakpointLocation(int lineNumber, int columnNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.columnNumber, this.className, this.methodName, this.methodSignature);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaBreakpointLocation)) {
            return false;
        }
        JavaBreakpointLocation other = (JavaBreakpointLocation)obj;
        return this.lineNumber == other.lineNumber && this.columnNumber == other.columnNumber && Objects.equals(this.className, other.className) && Objects.equals(this.methodName, other.methodName) && Objects.equals(this.methodSignature, other.methodSignature);
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int columnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public String className() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String methodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String methodSignature() {
        return this.methodSignature;
    }

    public void setMethodSignature(String methodSignature) {
        this.methodSignature = methodSignature;
    }

    public Types.BreakpointLocation[] availableBreakpointLocations() {
        return this.availableBreakpointLocations;
    }

    public void setAvailableBreakpointLocations(Types.BreakpointLocation[] availableBreakpointLocations) {
        this.availableBreakpointLocations = availableBreakpointLocations;
    }

    public int lineNumberInSourceFile() {
        return this.lineNumberInSourceFile == Integer.MIN_VALUE ? this.lineNumber : this.lineNumberInSourceFile;
    }

    public void setLineNumberInSourceFile(int lineNumberInSourceFile) {
        this.lineNumberInSourceFile = lineNumberInSourceFile;
    }
}

