/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.ArrayUtils;

public class SetExceptionBreakpointsRequestHandler
implements IDebugRequestHandler,
DebugSettings.IDebugSettingChangeListener {
    private IDebugSession debugSession = null;
    private boolean isInitialized = false;
    private boolean notifyCaught = false;
    private boolean notifyUncaught = false;
    private boolean asyncJDWP = false;

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SETEXCEPTIONBREAKPOINTS);
    }

    @Override
    public synchronized CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        if (context.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Empty debug session.");
        }
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.debugSession = context.getDebugSession();
            this.asyncJDWP = context.asyncJDWP();
            DebugSettings.addDebugSettingChangeListener(this);
            this.debugSession.getEventHub().events().subscribe(debugEvent -> {
                if (debugEvent.event instanceof VMDeathEvent || debugEvent.event instanceof VMDisconnectEvent) {
                    DebugSettings.removeDebugSettingChangeListener(this);
                }
            });
        }
        Object[] filters = ((Requests.SetExceptionBreakpointsArguments)arguments).filters;
        try {
            this.notifyCaught = ArrayUtils.contains((Object[])filters, (Object)"caught");
            this.notifyUncaught = ArrayUtils.contains((Object[])filters, (Object)"uncaught");
            this.setExceptionBreakpoints(context.getDebugSession(), this.notifyCaught, this.notifyUncaught);
            return CompletableFuture.completedFuture(response);
        }
        catch (Exception ex) {
            throw AdapterUtils.createCompletionException(String.format("Failed to setExceptionBreakpoints. Reason: '%s'", ex.toString()), ErrorCode.SET_EXCEPTIONBREAKPOINT_FAILURE, ex);
        }
    }

    private void setExceptionBreakpoints(IDebugSession debugSession, boolean notifyCaught, boolean notifyUncaught) {
        Requests.ExceptionFilters exceptionFilters = DebugSettings.getCurrent().exceptionFilters;
        String[] exceptionTypes = exceptionFilters == null ? null : exceptionFilters.exceptionTypes;
        String[] classFilters = exceptionFilters == null ? null : exceptionFilters.allowClasses;
        String[] classExclusionFilters = exceptionFilters == null ? null : exceptionFilters.skipClasses;
        debugSession.setExceptionBreakpoints(notifyCaught, notifyUncaught, exceptionTypes, classFilters, classExclusionFilters, this.asyncJDWP);
    }

    @Override
    public synchronized void update(DebugSettings oldSettings, DebugSettings newSettings) {
        try {
            if (newSettings != null && newSettings.exceptionFiltersUpdated) {
                this.setExceptionBreakpoints(this.debugSession, this.notifyCaught, this.notifyUncaught);
            }
        }
        catch (Exception ex) {
            DebugSettings.removeDebugSettingChangeListener(this);
        }
    }
}

