/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.Breakpoint;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.EventHub;
import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.IEventHub;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.util.ArrayList;
import java.util.List;

public class DebugSession
implements IDebugSession {
    private VirtualMachine vm;
    private EventHub eventHub = new EventHub();

    public DebugSession(VirtualMachine virtualMachine) {
        this.vm = virtualMachine;
    }

    @Override
    public void start() {
        ThreadStartRequest threadStartRequest = this.vm.eventRequestManager().createThreadStartRequest();
        threadStartRequest.setSuspendPolicy(0);
        threadStartRequest.enable();
        ThreadDeathRequest threadDeathRequest = this.vm.eventRequestManager().createThreadDeathRequest();
        threadDeathRequest.setSuspendPolicy(0);
        threadDeathRequest.enable();
        this.eventHub.start(this.vm);
    }

    @Override
    public void suspend() {
        this.vm.suspend();
    }

    @Override
    public void resume() {
        for (ThreadReference tr : DebugUtility.getAllThreadsSafely(this)) {
            while (!tr.isCollected() && tr.suspendCount() > 1) {
                tr.resume();
            }
        }
        this.vm.resume();
    }

    @Override
    public void detach() {
        this.vm.dispose();
    }

    @Override
    public void terminate() {
        if (this.vm.process() == null || this.vm.process().isAlive()) {
            this.vm.exit(0);
        }
    }

    @Override
    public IBreakpoint createBreakpoint(String className, int lineNumber) {
        return new Breakpoint(this.vm, this.getEventHub(), className, lineNumber);
    }

    @Override
    public IBreakpoint createBreakpoint(String className, int lineNumber, int hitCount) {
        return new Breakpoint(this.vm, this.getEventHub(), className, lineNumber, hitCount);
    }

    @Override
    public void setExceptionBreakpoints(boolean notifyCaught, boolean notifyUncaught) {
        EventRequestManager manager = this.vm.eventRequestManager();
        ArrayList<ExceptionRequest> legacy = new ArrayList<ExceptionRequest>(manager.exceptionRequests());
        manager.deleteEventRequests(legacy);
        if (notifyCaught || notifyUncaught) {
            ExceptionRequest request = manager.createExceptionRequest(null, notifyCaught, notifyUncaught);
            request.setSuspendPolicy(1);
            request.enable();
        }
    }

    @Override
    public Process process() {
        return this.vm.process();
    }

    @Override
    public List<ThreadReference> getAllThreads() {
        return this.vm.allThreads();
    }

    @Override
    public IEventHub getEventHub() {
        return this.eventHub;
    }

    @Override
    public VirtualMachine getVM() {
        return this.vm;
    }
}

