/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;

public final class StackFrameUtility {
    public static boolean isNative(StackFrame frame) {
        return frame.location().method().isNative();
    }

    public static boolean pop(StackFrame frame) {
        try {
            frame.thread().popFrames(frame);
        }
        catch (IncompatibleThreadStateException e) {
            return false;
        }
        return true;
    }

    public static String getName(StackFrame frame) {
        return frame.location().method().name();
    }

    public static String getSignature(StackFrame frame) {
        return frame.location().method().signature();
    }

    public static boolean isObsolete(StackFrame frame) {
        return frame.location().method().isObsolete();
    }

    public static String getSourcePath(StackFrame frame) {
        try {
            return frame.location().sourcePath();
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    public static ReferenceType getDeclaringType(StackFrame frame) {
        return frame.location().method().declaringType();
    }
}

