/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.IBreakpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BreakpointManager {
    private static final Logger logger = Logger.getLogger("java-debug");
    private List<IBreakpoint> breakpoints;
    private HashMap<String, HashMap<String, IBreakpoint>> sourceToBreakpoints;
    private AtomicInteger nextBreakpointId = new AtomicInteger(1);

    public BreakpointManager() {
        this.breakpoints = Collections.synchronizedList(new ArrayList(5));
        this.sourceToBreakpoints = new HashMap();
    }

    public IBreakpoint[] setBreakpoints(String source, IBreakpoint[] breakpoints) {
        return this.setBreakpoints(source, breakpoints, false);
    }

    public IBreakpoint[] setBreakpoints(String source, IBreakpoint[] breakpoints, boolean sourceModified) {
        ArrayList<IBreakpoint> result = new ArrayList<IBreakpoint>();
        HashMap<String, IBreakpoint> breakpointMap = this.sourceToBreakpoints.get(source);
        if (sourceModified && breakpointMap != null) {
            for (IBreakpoint bp : breakpointMap.values()) {
                try {
                    bp.close();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, String.format("Remove breakpoint exception: %s", e.toString()), e);
                }
                this.breakpoints.remove(bp);
            }
            this.sourceToBreakpoints.put(source, null);
            breakpointMap = null;
        }
        if (breakpointMap == null) {
            breakpointMap = new HashMap();
            this.sourceToBreakpoints.put(source, breakpointMap);
        }
        ArrayList<IBreakpoint> toAdd = new ArrayList<IBreakpoint>();
        ArrayList<Integer> visitedLineNumbers = new ArrayList<Integer>();
        for (IBreakpoint breakpoint : breakpoints) {
            IBreakpoint existed = breakpointMap.get(String.valueOf(breakpoint.lineNumber()));
            if (existed != null) {
                result.add(existed);
                visitedLineNumbers.add(existed.lineNumber());
                continue;
            }
            result.add(breakpoint);
            toAdd.add(breakpoint);
        }
        ArrayList<IBreakpoint> toRemove = new ArrayList<IBreakpoint>();
        for (IBreakpoint breakpoint : breakpointMap.values()) {
            if (visitedLineNumbers.contains(breakpoint.lineNumber())) continue;
            toRemove.add(breakpoint);
        }
        this.removeBreakpointsInternally(source, toRemove.toArray(new IBreakpoint[0]));
        this.addBreakpointsInternally(source, toAdd.toArray(new IBreakpoint[0]));
        return result.toArray(new IBreakpoint[0]);
    }

    private void addBreakpointsInternally(String source, IBreakpoint[] breakpoints) {
        Map breakpointMap = this.sourceToBreakpoints.computeIfAbsent(source, k -> new HashMap());
        if (breakpoints != null && breakpoints.length > 0) {
            for (IBreakpoint breakpoint : breakpoints) {
                breakpoint.putProperty("id", this.nextBreakpointId.getAndIncrement());
                this.breakpoints.add(breakpoint);
                breakpointMap.put(String.valueOf(breakpoint.lineNumber()), breakpoint);
            }
        }
    }

    private void removeBreakpointsInternally(String source, IBreakpoint[] breakpoints) {
        Map breakpointMap = this.sourceToBreakpoints.get(source);
        if (breakpointMap == null || breakpointMap.isEmpty() || breakpoints.length == 0) {
            return;
        }
        for (IBreakpoint breakpoint : breakpoints) {
            if (!this.breakpoints.contains(breakpoint)) continue;
            try {
                breakpoint.close();
                this.breakpoints.remove(breakpoint);
                breakpointMap.remove(String.valueOf(breakpoint.lineNumber()));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Remove breakpoint exception: %s", e.toString()), e);
            }
        }
    }

    public IBreakpoint[] getBreakpoints() {
        return this.breakpoints.toArray(new IBreakpoint[0]);
    }

    public IBreakpoint[] getBreakpoints(String source) {
        HashMap<String, IBreakpoint> breakpointMap = this.sourceToBreakpoints.get(source);
        if (breakpointMap == null) {
            return new IBreakpoint[0];
        }
        return breakpointMap.values().toArray(new IBreakpoint[0]);
    }

    public void reset() {
        this.sourceToBreakpoints.clear();
        this.breakpoints.clear();
        this.nextBreakpointId.set(1);
    }
}

