/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.BreakpointManager;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class SetBreakpointsRequestHandler
implements IDebugRequestHandler {
    private static final Logger logger = Logger.getLogger("java-debug");
    private BreakpointManager manager = new BreakpointManager();
    private boolean isHcrInitialized = false;

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SETBREAKPOINTS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        String drivePrefix;
        if (!this.isHcrInitialized) {
            IHotCodeReplaceProvider hcrProvider = context.getProvider(IHotCodeReplaceProvider.class);
            hcrProvider.onClassRedefined(typenames -> this.reinstallBreakpoints(context, (List<String>)typenames));
            this.isHcrInitialized = true;
        }
        if (context.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Empty debug session.");
        }
        Requests.SetBreakpointArguments bpArguments = (Requests.SetBreakpointArguments)arguments;
        String clientPath = bpArguments.source.path;
        if (AdapterUtils.isWindows() && (drivePrefix = FilenameUtils.getPrefix((String)clientPath)) != null && drivePrefix.length() >= 2 && Character.isLowerCase(drivePrefix.charAt(0)) && drivePrefix.charAt(1) == ':') {
            drivePrefix = drivePrefix.substring(0, 2);
            clientPath = clientPath.replaceFirst(drivePrefix, drivePrefix.toUpperCase());
        }
        String sourcePath = clientPath;
        if (bpArguments.source.sourceReference != 0 && context.getSourceUri(bpArguments.source.sourceReference) != null) {
            sourcePath = context.getSourceUri(bpArguments.source.sourceReference);
        } else if (StringUtils.isNotBlank((CharSequence)clientPath)) {
            sourcePath = AdapterUtils.convertPath(clientPath, AdapterUtils.isUri(clientPath), context.isDebuggerPathsAreUri());
        }
        if (StringUtils.isBlank((CharSequence)sourcePath)) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.SET_BREAKPOINT_FAILURE, String.format("Failed to setBreakpoint. Reason: '%s' is an invalid path.", bpArguments.source.path));
        }
        try {
            ArrayList<Types.Breakpoint> res = new ArrayList<Types.Breakpoint>();
            IBreakpoint[] toAdds = this.convertClientBreakpointsToDebugger(sourcePath, bpArguments.breakpoints, context);
            IBreakpoint[] added = this.manager.setBreakpoints(AdapterUtils.decodeURIComponent(sourcePath), toAdds, bpArguments.sourceModified);
            for (int i = 0; i < bpArguments.breakpoints.length; ++i) {
                if (toAdds[i] == added[i] && added[i].className() != null) {
                    added[i].install().thenAccept(bp -> {
                        Events.BreakpointEvent bpEvent = new Events.BreakpointEvent("new", this.convertDebuggerBreakpointToClient((IBreakpoint)bp, context));
                        context.getProtocolServer().sendEvent(bpEvent);
                    });
                } else if (toAdds[i].hitCount() != added[i].hitCount() && added[i].className() != null) {
                    added[i].setHitCount(toAdds[i].hitCount());
                }
                res.add(this.convertDebuggerBreakpointToClient(added[i], context));
            }
            response.body = new Responses.SetBreakpointsResponseBody(res);
            return CompletableFuture.completedFuture(response);
        }
        catch (DebugException e) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.SET_BREAKPOINT_FAILURE, String.format("Failed to setBreakpoint. Reason: '%s'", e.toString()));
        }
    }

    private Types.Breakpoint convertDebuggerBreakpointToClient(IBreakpoint breakpoint, IDebugAdapterContext context) {
        int id = (Integer)breakpoint.getProperty("id");
        boolean verified = breakpoint.getProperty("verified") != null && (Boolean)breakpoint.getProperty("verified") != false;
        int lineNumber = AdapterUtils.convertLineNumber(breakpoint.lineNumber(), context.isDebuggerLinesStartAt1(), context.isClientLinesStartAt1());
        return new Types.Breakpoint(id, verified, lineNumber, "");
    }

    private IBreakpoint[] convertClientBreakpointsToDebugger(String sourceFile, Types.SourceBreakpoint[] sourceBreakpoints, IDebugAdapterContext context) throws DebugException {
        int[] lines = Arrays.asList(sourceBreakpoints).stream().map(sourceBreakpoint -> AdapterUtils.convertLineNumber(sourceBreakpoint.line, context.isClientLinesStartAt1(), context.isDebuggerLinesStartAt1())).mapToInt(line -> line).toArray();
        ISourceLookUpProvider sourceProvider = context.getProvider(ISourceLookUpProvider.class);
        String[] fqns = sourceProvider.getFullyQualifiedName(sourceFile, lines, null);
        IBreakpoint[] breakpoints = new IBreakpoint[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            int hitCount = 0;
            try {
                hitCount = Integer.parseInt(sourceBreakpoints[i].hitCondition);
            }
            catch (NumberFormatException e) {
                hitCount = 0;
            }
            breakpoints[i] = context.getDebugSession().createBreakpoint(fqns[i], lines[i], hitCount);
            if (!sourceProvider.supportsRealtimeBreakpointVerification() || !StringUtils.isNotBlank((CharSequence)fqns[i])) continue;
            breakpoints[i].putProperty("verified", true);
        }
        return breakpoints;
    }

    private void reinstallBreakpoints(IDebugAdapterContext context, List<String> typenames) {
        IBreakpoint[] breakpoints;
        if (typenames == null || typenames.isEmpty()) {
            return;
        }
        for (IBreakpoint breakpoint : breakpoints = this.manager.getBreakpoints()) {
            if (!typenames.contains(breakpoint.className())) continue;
            try {
                breakpoint.close();
                breakpoint.install().thenAccept(bp -> {
                    Events.BreakpointEvent bpEvent = new Events.BreakpointEvent("new", this.convertDebuggerBreakpointToClient((IBreakpoint)bp, context));
                    context.getProtocolServer().sendEvent(bpEvent);
                });
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Remove breakpoint exception: %s", e.toString()), e);
            }
        }
    }
}

