/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadCache {
    private List<ThreadReference> allThreads = new ArrayList<ThreadReference>();
    private Map<Long, String> threadNameMap = new ConcurrentHashMap<Long, String>();
    private Map<Long, Boolean> deathThreads = Collections.synchronizedMap(new LinkedHashMap<Long, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, Boolean> eldest) {
            return this.size() > 100;
        }
    });
    private Map<Long, ThreadReference> eventThreads = new ConcurrentHashMap<Long, ThreadReference>();
    private Map<Long, Set<String>> decompiledClassesByThread = new HashMap<Long, Set<String>>();
    private Map<Long, String> threadStoppedReasons = new HashMap<Long, String>();

    public synchronized void resetThreads(List<ThreadReference> threads) {
        this.allThreads.clear();
        this.allThreads.addAll(threads);
    }

    public synchronized List<ThreadReference> getThreads() {
        return this.allThreads;
    }

    public synchronized ThreadReference getThread(long threadId) {
        for (ThreadReference thread : this.allThreads) {
            if (threadId != thread.uniqueID()) continue;
            return thread;
        }
        for (ThreadReference thread : this.eventThreads.values()) {
            if (threadId != thread.uniqueID()) continue;
            return thread;
        }
        return null;
    }

    public void setThreadName(long threadId, String name) {
        this.threadNameMap.put(threadId, name);
    }

    public String getThreadName(long threadId) {
        return this.threadNameMap.get(threadId);
    }

    public void addDeathThread(long threadId) {
        this.threadNameMap.remove(threadId);
        this.eventThreads.remove(threadId);
        this.deathThreads.put(threadId, true);
    }

    public boolean isDeathThread(long threadId) {
        return this.deathThreads.containsKey(threadId);
    }

    public void addEventThread(ThreadReference thread) {
        this.eventThreads.put(thread.uniqueID(), thread);
    }

    public void addEventThread(ThreadReference thread, String reason) {
        this.eventThreads.put(thread.uniqueID(), thread);
        if (reason != null) {
            this.threadStoppedReasons.put(thread.uniqueID(), reason);
        }
    }

    public void removeEventThread(long threadId) {
        this.eventThreads.remove(threadId);
    }

    public void clearEventThread() {
        this.eventThreads.clear();
    }

    public List<ThreadReference> visibleThreads(IDebugAdapterContext context) {
        ArrayList<ThreadReference> visibleThreads = new ArrayList<ThreadReference>(context.getDebugSession().getAllThreads());
        HashSet<Long> idSet = new HashSet<Long>();
        visibleThreads.forEach(thread -> idSet.add(thread.uniqueID()));
        for (ThreadReference thread2 : this.eventThreads.values()) {
            if (idSet.contains(thread2.uniqueID())) continue;
            idSet.add(thread2.uniqueID());
            visibleThreads.add(thread2);
        }
        return visibleThreads;
    }

    public Set<String> getDecompiledClassesByThread(long threadId) {
        return this.decompiledClassesByThread.get(threadId);
    }

    public void setDecompiledClassesByThread(long threadId, Set<String> decompiledClasses) {
        if (decompiledClasses == null || decompiledClasses.isEmpty()) {
            this.decompiledClassesByThread.remove(threadId);
            return;
        }
        this.decompiledClassesByThread.put(threadId, decompiledClasses);
    }

    public String getThreadStoppedReason(long threadId) {
        return this.threadStoppedReasons.get(threadId);
    }

    public void setThreadStoppedReason(long threadId, String reason) {
        if (reason == null) {
            this.threadStoppedReasons.remove(threadId);
            return;
        }
        this.threadStoppedReasons.put(threadId, reason);
    }

    public void clearThreadStoppedState(long threadId) {
        this.threadStoppedReasons.remove(threadId);
        this.decompiledClassesByThread.remove(threadId);
    }

    public void clearAllThreadStoppedState() {
        this.threadStoppedReasons.clear();
        this.decompiledClassesByThread.clear();
    }
}

