/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.IWatchpoint;
import com.microsoft.java.debug.core.Watchpoint;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.handler.SetBreakpointsRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.WatchpointEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SetDataBreakpointsRequestHandler
implements IDebugRequestHandler {
    private boolean registered = false;

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SETDATABREAKPOINTS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        if (context.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Empty debug session.");
        }
        if (!this.registered) {
            this.registered = true;
            this.registerWatchpointHandler(context);
        }
        Requests.SetDataBreakpointsArguments dataBpArgs = (Requests.SetDataBreakpointsArguments)arguments;
        IWatchpoint[] requestedWatchpoints = dataBpArgs.breakpoints == null ? new Watchpoint[]{} : new Watchpoint[dataBpArgs.breakpoints.length];
        for (int i = 0; i < requestedWatchpoints.length; ++i) {
            String[] segments;
            Types.DataBreakpoint dataBreakpoint = dataBpArgs.breakpoints[i];
            if (dataBreakpoint.dataId == null || (segments = dataBreakpoint.dataId.split("#")).length != 2 || !StringUtils.isNotBlank((CharSequence)segments[0]) || !StringUtils.isNotBlank((CharSequence)segments[1])) continue;
            int hitCount = 0;
            try {
                hitCount = Integer.parseInt(dataBreakpoint.hitCondition);
            }
            catch (NumberFormatException e) {
                hitCount = 0;
            }
            String accessType = dataBreakpoint.accessType != null ? dataBreakpoint.accessType.label() : null;
            requestedWatchpoints[i] = context.getDebugSession().createWatchPoint(segments[0], segments[1], accessType, dataBreakpoint.condition, hitCount);
        }
        IWatchpoint[] currentWatchpoints = context.getBreakpointManager().setWatchpoints(requestedWatchpoints);
        ArrayList<Types.Breakpoint> breakpoints = new ArrayList<Types.Breakpoint>();
        for (int i = 0; i < currentWatchpoints.length; ++i) {
            if (currentWatchpoints[i] == null) {
                breakpoints.add(new Types.Breakpoint(false));
                continue;
            }
            if (currentWatchpoints[i] == requestedWatchpoints[i]) {
                currentWatchpoints[i].install().thenAccept(wp -> {
                    Events.BreakpointEvent bpEvent = new Events.BreakpointEvent("new", this.convertDebuggerWatchpointToClient((IWatchpoint)wp));
                    context.getProtocolServer().sendEvent(bpEvent);
                });
            } else {
                if (currentWatchpoints[i].getHitCount() != requestedWatchpoints[i].getHitCount()) {
                    currentWatchpoints[i].setHitCount(requestedWatchpoints[i].getHitCount());
                }
                if (!Objects.equals(currentWatchpoints[i].getCondition(), requestedWatchpoints[i].getCondition())) {
                    currentWatchpoints[i].setCondition(requestedWatchpoints[i].getCondition());
                }
            }
            breakpoints.add(this.convertDebuggerWatchpointToClient(currentWatchpoints[i]));
        }
        response.body = new Responses.SetDataBreakpointsResponseBody(breakpoints);
        return CompletableFuture.completedFuture(response);
    }

    private Types.Breakpoint convertDebuggerWatchpointToClient(IWatchpoint watchpoint) {
        return new Types.Breakpoint((Integer)watchpoint.getProperty("id"), watchpoint.getProperty("verified") != null && (Boolean)watchpoint.getProperty("verified") != false);
    }

    private void registerWatchpointHandler(IDebugAdapterContext context) {
        IDebugSession debugSession = context.getDebugSession();
        if (debugSession != null) {
            debugSession.getEventHub().events().filter(debugEvent -> debugEvent.event instanceof WatchpointEvent).subscribe(debugEvent -> {
                Event event = debugEvent.event;
                ThreadReference bpThread = ((WatchpointEvent)event).thread();
                IEvaluationProvider engine = context.getProvider(IEvaluationProvider.class);
                if (engine.isInEvaluation(bpThread)) {
                    return;
                }
                IWatchpoint watchpoint = Stream.of(context.getBreakpointManager().getWatchpoints()).filter(wp -> wp instanceof IEvaluatableBreakpoint && ((IEvaluatableBreakpoint)((Object)wp)).containsEvaluatableExpression() && wp.requests().contains(event.request())).findFirst().orElse(null);
                if (watchpoint != null) {
                    CompletableFuture.runAsync(() -> engine.evaluateForBreakpoint((IEvaluatableBreakpoint)((Object)watchpoint), bpThread).whenComplete((value, ex) -> {
                        boolean resume = SetBreakpointsRequestHandler.handleEvaluationResult(context, bpThread, (IEvaluatableBreakpoint)((Object)watchpoint), value, ex);
                        engine.clearState(bpThread);
                        if (resume) {
                            debugEvent.eventSet.resume();
                        } else {
                            context.getThreadCache().addEventThread(bpThread, "data breakpoint");
                            context.getProtocolServer().sendEvent(new Events.StoppedEvent("data breakpoint", bpThread.uniqueID()));
                        }
                    }));
                } else {
                    context.getThreadCache().addEventThread(bpThread, "data breakpoint");
                    context.getProtocolServer().sendEvent(new Events.StoppedEvent("data breakpoint", bpThread.uniqueID()));
                }
                debugEvent.shouldResume = false;
            });
        }
    }
}

