/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.AsyncJdwpUtils;
import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.formatter.NumericFormatEnum;
import com.microsoft.java.debug.core.adapter.variables.Variable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class VariableUtils {
    private static final Logger logger = Logger.getLogger("java-debug");

    public static boolean hasChildren(Value value, boolean includeStatic) {
        if (value == null || !(value instanceof ObjectReference)) {
            return false;
        }
        ReferenceType type = ((ObjectReference)value).referenceType();
        if (type instanceof ArrayType) {
            return ((ArrayReference)value).length() > 0;
        }
        return type.allFields().stream().anyMatch(t -> includeStatic || !t.isStatic());
    }

    public static List<Variable> listFieldVariables(ObjectReference obj, boolean includeStatic) throws AbsentInformationException {
        return VariableUtils.listFieldVariables(obj, includeStatic, false);
    }

    public static List<Variable> listFieldVariables(ObjectReference obj, boolean includeStatic, boolean async) throws AbsentInformationException {
        ArrayList<Variable> res = new ArrayList<Variable>();
        ReferenceType type = obj.referenceType();
        if (type instanceof ArrayType) {
            int arrayIndex = 0;
            boolean isUnboundedArrayType = Objects.equals(type.signature(), "[Ljava/lang/Object;");
            for (Value elementValue : ((ArrayReference)obj).getValues()) {
                Variable ele = new Variable(String.valueOf(arrayIndex++), elementValue);
                ele.setUnboundedType(isUnboundedArrayType);
                res.add(ele);
            }
            return res;
        }
        List fields = VariableUtils.resolveAllFields(type, async).stream().filter(t -> includeStatic || !t.isStatic()).sorted((a, b) -> {
            try {
                boolean v1isStatic = a.isStatic();
                boolean v2isStatic = b.isStatic();
                if (v1isStatic && !v2isStatic) {
                    return -1;
                }
                if (!v1isStatic && v2isStatic) {
                    return 1;
                }
                return a.name().compareToIgnoreCase(b.name());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Cannot sort fields: %s", e), e);
                return -1;
            }
        }).collect(Collectors.toList());
        VariableUtils.bulkFetchValues(fields, DebugSettings.getCurrent().limitOfVariablesPerJdwpRequest, currentPage -> {
            Map<Field, Value> fieldValues = obj.getValues((List<? extends Field>)currentPage);
            for (Field currentField : currentPage) {
                Variable var = new Variable(currentField.name(), fieldValues.get(currentField));
                var.field = currentField;
                res.add(var);
            }
        });
        return res;
    }

    public static List<Variable> listFieldVariables(ObjectReference obj, int start, int count) throws AbsentInformationException {
        ArrayList<Variable> res = new ArrayList<Variable>();
        Type type = obj.type();
        if (type instanceof ArrayType) {
            int arrayIndex = start;
            boolean isUnboundedArrayType = Objects.equals(type.signature(), "[Ljava/lang/Object;");
            for (Value elementValue : ((ArrayReference)obj).getValues(start, count)) {
                Variable variable = new Variable(String.valueOf(arrayIndex++), elementValue);
                variable.setUnboundedType(isUnboundedArrayType);
                res.add(variable);
            }
            return res;
        }
        throw new UnsupportedOperationException("Only Array type is supported.");
    }

    public static List<Variable> listLocalVariables(StackFrame stackFrame) throws AbsentInformationException {
        ArrayList<Variable> res;
        block10: {
            res = new ArrayList<Variable>();
            if (stackFrame.location().method().isNative()) {
                return res;
            }
            try {
                List<LocalVariable> visibleVariables = stackFrame.visibleVariables();
                VariableUtils.bulkFetchValues(visibleVariables, DebugSettings.getCurrent().limitOfVariablesPerJdwpRequest, currentPage -> {
                    Map<LocalVariable, Value> values = stackFrame.getValues((List<? extends LocalVariable>)currentPage);
                    for (LocalVariable localVariable : currentPage) {
                        Variable var = new Variable(localVariable.name(), values.get(localVariable));
                        var.local = localVariable;
                        res.add(var);
                    }
                });
            }
            catch (AbsentInformationException ex) {
                try {
                    if (stackFrame.location().method().argumentTypes().size() == 0) {
                        return res;
                    }
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    // empty catch block
                }
                int argId = 0;
                try {
                    List<Value> arguments = stackFrame.getArgumentValues();
                    if (arguments == null) {
                        return res;
                    }
                    for (Value argValue : arguments) {
                        Variable var = new Variable("arg" + argId, argValue);
                        var.argumentIndex = argId++;
                        res.add(var);
                    }
                }
                catch (InternalException ex2) {
                    if (ex2.errorCode() == 32) break block10;
                    throw ex;
                }
            }
        }
        return res;
    }

    public static CompletableFuture<List<Variable>> listLocalVariablesAsync(StackFrame stackFrame) {
        CompletableFuture<List<Variable>> future = new CompletableFuture<List<Variable>>();
        if (stackFrame.location().method().isNative()) {
            return CompletableFuture.completedFuture(new ArrayList());
        }
        ((CompletableFuture)AsyncJdwpUtils.supplyAsync(() -> {
            try {
                return stackFrame.visibleVariables();
            }
            catch (AbsentInformationException ex) {
                throw new CompletionException(ex);
            }
        }).thenCompose(visibleVariables -> VariableUtils.bulkFetchValuesAsync(visibleVariables, DebugSettings.getCurrent().limitOfVariablesPerJdwpRequest, currentPage -> {
            Map<LocalVariable, Value> values = stackFrame.getValues((List<? extends LocalVariable>)currentPage);
            ArrayList<Variable> result = new ArrayList<Variable>();
            for (LocalVariable localVariable : currentPage) {
                Variable var = new Variable(localVariable.name(), values.get(localVariable));
                var.local = localVariable;
                result.add(var);
            }
            return result;
        }))).whenComplete((res, ex) -> {
            if (ex instanceof CompletionException && ex.getCause() != null) {
                ex = ex.getCause();
            }
            if (ex instanceof AbsentInformationException) {
                try {
                    if (stackFrame.location().method().argumentTypes().size() == 0) {
                        future.complete(new ArrayList());
                        return;
                    }
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    // empty catch block
                }
                int argId = 0;
                try {
                    List<Value> arguments = stackFrame.getArgumentValues();
                    if (arguments == null) {
                        future.complete(new ArrayList());
                        return;
                    }
                    ArrayList<Variable> variables = new ArrayList<Variable>();
                    for (Value argValue : arguments) {
                        Variable var = new Variable("arg" + argId, argValue);
                        var.argumentIndex = argId++;
                        variables.add(var);
                    }
                    future.complete(variables);
                    return;
                }
                catch (InternalException ex2) {
                    if (ex2.errorCode() == 32) return;
                    throw ex2;
                }
            }
            if (ex != null) {
                future.complete(new ArrayList());
                return;
            } else {
                future.complete(res.stream().flatMap(Collection::stream).collect(Collectors.toList()));
            }
        });
        return future;
    }

    public static Variable getThisVariable(StackFrame stackFrame) {
        ObjectReference thisObject = stackFrame.thisObject();
        if (thisObject == null) {
            return null;
        }
        return new Variable("this", thisObject);
    }

    public static CompletableFuture<Variable> getThisVariableAsync(StackFrame stackFrame) {
        return AsyncJdwpUtils.supplyAsync(() -> {
            ObjectReference thisObject = stackFrame.thisObject();
            if (thisObject == null) {
                return null;
            }
            return new Variable("this", thisObject);
        });
    }

    public static List<Variable> listStaticVariables(StackFrame stackFrame) {
        ArrayList<Variable> res = new ArrayList<Variable>();
        ReferenceType type = stackFrame.location().declaringType();
        List fields = type.allFields().stream().filter(TypeComponent::isStatic).collect(Collectors.toList());
        VariableUtils.bulkFetchValues(fields, DebugSettings.getCurrent().limitOfVariablesPerJdwpRequest, currentPage -> {
            Map<Field, Value> fieldValues = type.getValues((List<? extends Field>)currentPage);
            for (Field currentField : currentPage) {
                Variable var = new Variable(currentField.name(), fieldValues.get(currentField));
                var.field = currentField;
                res.add(var);
            }
        });
        return res;
    }

    public static CompletableFuture<List<Variable>> listStaticVariablesAsync(StackFrame stackFrame) {
        CompletableFuture<List<Variable>> future = new CompletableFuture<List<Variable>>();
        ReferenceType type = stackFrame.location().declaringType();
        ((CompletableFuture)AsyncJdwpUtils.supplyAsync(() -> type.allFields().stream().filter(TypeComponent::isStatic).collect(Collectors.toList())).thenCompose(fields -> VariableUtils.bulkFetchValuesAsync(fields, DebugSettings.getCurrent().limitOfVariablesPerJdwpRequest, currentPage -> {
            ArrayList<Variable> variables = new ArrayList<Variable>();
            Map<Field, Value> fieldValues = type.getValues((List<? extends Field>)currentPage);
            for (Field currentField : currentPage) {
                Variable var = new Variable(currentField.name(), fieldValues.get(currentField));
                var.field = currentField;
                variables.add(var);
            }
            return variables;
        }))).whenComplete((res, ex) -> {
            if (ex instanceof CompletionException && ex.getCause() != null) {
                ex = ex.getCause();
            }
            if (ex != null) {
                future.complete(new ArrayList());
            } else {
                future.complete(res.stream().flatMap(Collection::stream).collect(Collectors.toList()));
            }
        });
        return future;
    }

    public static void applyFormatterOptions(Map<String, Object> defaultOptions, boolean hexInArgument) {
        Map<String, Object> options = defaultOptions;
        boolean showFullyQualifiedNames = DebugSettings.getCurrent().showQualifiedNames;
        if (hexInArgument || DebugSettings.getCurrent().showHex) {
            options.put("numeric_format", (Object)NumericFormatEnum.HEX);
        }
        if (showFullyQualifiedNames) {
            options.put("qualified_class_name", true);
        }
        if (DebugSettings.getCurrent().maxStringLength > 0) {
            options.put("max_string_length", DebugSettings.getCurrent().maxStringLength);
        }
        if (DebugSettings.getCurrent().numericPrecision > 0) {
            options.put("numeric_precision", DebugSettings.getCurrent().numericPrecision);
        }
    }

    public static String getEvaluateName(String name, String containerName, boolean isArrayElement) {
        if (name == null) {
            return null;
        }
        if (isArrayElement) {
            if (containerName == null) {
                return null;
            }
            return String.format("%s[%s]", containerName, name);
        }
        if (containerName == null) {
            return name;
        }
        return String.format("%s.%s", containerName, name);
    }

    private static <T> void bulkFetchValues(List<T> elements, int numberPerPage, Consumer<List<T>> consumer) {
        int size = elements.size();
        numberPerPage = numberPerPage < 1 ? 1 : numberPerPage;
        int page = size / numberPerPage + Math.min(size % numberPerPage, 1);
        for (int i = 0; i < page; ++i) {
            int pageStart = i * numberPerPage;
            int pageEnd = Math.min(pageStart + numberPerPage, size);
            List<T> currentPage = elements.subList(pageStart, pageEnd);
            consumer.accept(currentPage);
        }
    }

    private static <T, R> CompletableFuture<List<R>> bulkFetchValuesAsync(List<T> elements, int numberPerPage, Function<List<T>, R> function) {
        int size = elements.size();
        numberPerPage = numberPerPage < 1 ? 1 : numberPerPage;
        int page = size / numberPerPage + Math.min(size % numberPerPage, 1);
        ArrayList futures = new ArrayList();
        for (int i = 0; i < page; ++i) {
            int pageStart = i * numberPerPage;
            int pageEnd = Math.min(pageStart + numberPerPage, size);
            List currentPage = elements.subList(pageStart, pageEnd);
            futures.add(AsyncJdwpUtils.supplyAsync(() -> function.apply(currentPage)));
        }
        return AsyncJdwpUtils.all(futures);
    }

    private static List<Field> resolveAllFields(ReferenceType type, boolean async) {
        if (async) {
            return VariableUtils.resolveAllFieldsAsync(type);
        }
        return type.allFields();
    }

    private static List<Field> resolveAllFieldsAsync(ReferenceType type) {
        Set<Field> result = Collections.synchronizedSet(new HashSet());
        AsyncJdwpUtils.await(VariableUtils.resolveAllFieldsAsync(type, result));
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(result);
        return fields;
    }

    private static CompletableFuture<Void> resolveAllFieldsAsync(ReferenceType type, Set<Field> result) {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        futures.add(AsyncJdwpUtils.runAsync(() -> result.addAll(type.fields())));
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            futures.add(AsyncJdwpUtils.supplyAsync(() -> classType.interfaces()).thenCompose(its -> {
                ArrayList<CompletableFuture<Void>> itFutures = new ArrayList<CompletableFuture<Void>>();
                for (InterfaceType it : its) {
                    itFutures.add(VariableUtils.resolveAllFieldsAsync(it, result));
                }
                return CompletableFuture.allOf(itFutures.toArray(new CompletableFuture[0]));
            }));
            AsyncJdwpUtils.supplyAsync(() -> classType.superclass()).thenCompose(superclass -> {
                if (superclass != null) {
                    return VariableUtils.resolveAllFieldsAsync(superclass, result);
                }
                return CompletableFuture.completedFuture(null);
            });
        } else if (type instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)type;
            futures.add(AsyncJdwpUtils.supplyAsync(() -> interfaceType.superinterfaces()).thenCompose(its -> {
                ArrayList<CompletableFuture<Void>> itFutures = new ArrayList<CompletableFuture<Void>>();
                for (InterfaceType it : its) {
                    itFutures.add(VariableUtils.resolveAllFieldsAsync(it, result));
                }
                return CompletableFuture.allOf(itFutures.toArray(new CompletableFuture[0]));
            }));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private VariableUtils() {
    }
}

