/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;

public class AsyncJdwpUtils {
    public static ExecutorService jdwpThreadPool = Executors.newWorkStealingPool(100);

    public static CompletableFuture<Void> runAsync(List<Runnable> tasks) {
        return AsyncJdwpUtils.runAsync((Executor)jdwpThreadPool, tasks.toArray(new Runnable[0]));
    }

    public static CompletableFuture<Void> runAsync(Runnable ... tasks) {
        return AsyncJdwpUtils.runAsync((Executor)jdwpThreadPool, tasks);
    }

    public static CompletableFuture<Void> runAsync(Executor executor, List<Runnable> tasks) {
        return AsyncJdwpUtils.runAsync(executor, tasks.toArray(new Runnable[0]));
    }

    public static CompletableFuture<Void> runAsync(Executor executor, Runnable ... tasks) {
        ArrayList<CompletableFuture<Void>> promises = new ArrayList<CompletableFuture<Void>>();
        for (Runnable task : tasks) {
            if (task == null) continue;
            promises.add(CompletableFuture.runAsync(task, executor));
        }
        return CompletableFuture.allOf(promises.toArray(new CompletableFuture[0]));
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return AsyncJdwpUtils.supplyAsync(jdwpThreadPool, supplier);
    }

    public static <U> CompletableFuture<U> supplyAsync(Executor executor, Supplier<U> supplier) {
        return CompletableFuture.supplyAsync(supplier, executor);
    }

    public static <U> U await(CompletableFuture<U> future) {
        try {
            return future.join();
        }
        catch (CompletionException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw ex;
        }
    }

    public static <U> List<U> await(CompletableFuture<U>[] futures) {
        ArrayList<U> results = new ArrayList<U>();
        try {
            CompletableFuture.allOf(futures).join();
            for (CompletableFuture<U> future : futures) {
                results.add(AsyncJdwpUtils.await(future));
            }
        }
        catch (CompletionException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw ex;
        }
        return results;
    }

    public static <U> List<U> await(List<CompletableFuture<U>> futures) {
        return AsyncJdwpUtils.await(futures.toArray(new CompletableFuture[0]));
    }

    public static <U> CompletableFuture<List<U>> all(CompletableFuture<U> ... futures) {
        return CompletableFuture.allOf(futures).thenApply(res -> {
            ArrayList results = new ArrayList();
            for (CompletableFuture future : futures) {
                results.add(future.join());
            }
            return results;
        });
    }

    public static <U> CompletableFuture<List<U>> all(List<CompletableFuture<U>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(res -> {
            ArrayList results = new ArrayList();
            for (CompletableFuture future : futures) {
                results.add(future.join());
            }
            return results;
        });
    }

    public static <U> CompletableFuture<List<U>> flatAll(CompletableFuture<List<U>> ... futures) {
        return CompletableFuture.allOf(futures).thenApply(res -> {
            ArrayList results = new ArrayList();
            for (CompletableFuture future : futures) {
                results.addAll((Collection)future.join());
            }
            return results;
        });
    }

    public static <U> CompletableFuture<List<U>> flatAll(List<CompletableFuture<List<U>>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(res -> {
            ArrayList results = new ArrayList();
            for (CompletableFuture future : futures) {
                results.addAll((Collection)future.join());
            }
            return results;
        });
    }
}

