/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.Breakpoint;
import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.IEventHub;
import com.microsoft.java.debug.core.JavaBreakpointLocation;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ThreadDeathEvent;
import io.reactivex.disposables.Disposable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class EvaluatableBreakpoint
extends Breakpoint
implements IEvaluatableBreakpoint {
    private IEventHub eventHub = null;
    private Object compiledConditionalExpression = null;
    private Object compiledLogpointExpression = null;
    private Map<Long, Object> compiledExpressions = new ConcurrentHashMap<Long, Object>();

    EvaluatableBreakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber) {
        this(vm, eventHub, className, lineNumber, 0, null);
    }

    EvaluatableBreakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount) {
        this(vm, eventHub, className, lineNumber, hitCount, null);
    }

    EvaluatableBreakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount, String condition) {
        this(vm, eventHub, className, lineNumber, hitCount, condition, null);
    }

    EvaluatableBreakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount, String condition, String logMessage) {
        super(vm, eventHub, className, lineNumber, hitCount, condition, logMessage);
        this.eventHub = eventHub;
    }

    EvaluatableBreakpoint(VirtualMachine vm, IEventHub eventHub, JavaBreakpointLocation sourceLocation, int hitCount, String condition, String logMessage) {
        super(vm, eventHub, sourceLocation, hitCount, condition, logMessage);
        this.eventHub = eventHub;
    }

    @Override
    public boolean containsEvaluatableExpression() {
        return this.containsConditionalExpression() || this.containsLogpointExpression();
    }

    @Override
    public boolean containsConditionalExpression() {
        return StringUtils.isNotBlank((CharSequence)this.getCondition());
    }

    @Override
    public boolean containsLogpointExpression() {
        return StringUtils.isNotBlank((CharSequence)this.getLogMessage());
    }

    @Override
    public void setCompiledConditionalExpression(Object compiledExpression) {
        this.compiledConditionalExpression = compiledExpression;
    }

    @Override
    public Object getCompiledConditionalExpression() {
        return this.compiledConditionalExpression;
    }

    @Override
    public void setCompiledLogpointExpression(Object compiledExpression) {
        this.compiledLogpointExpression = compiledExpression;
    }

    @Override
    public Object getCompiledLogpointExpression() {
        return this.compiledLogpointExpression;
    }

    @Override
    public void setCondition(String condition) {
        super.setCondition(condition);
        this.setCompiledConditionalExpression(null);
        this.compiledExpressions.clear();
    }

    @Override
    public void setLogMessage(String logMessage) {
        super.setLogMessage(logMessage);
        this.setCompiledLogpointExpression(null);
        this.compiledExpressions.clear();
    }

    @Override
    public Object getCompiledExpression(long threadId) {
        return this.compiledExpressions.get(threadId);
    }

    @Override
    public void setCompiledExpression(long threadId, Object compiledExpression) {
        this.compiledExpressions.put(threadId, compiledExpression);
    }

    @Override
    public CompletableFuture<IBreakpoint> install() {
        Disposable subscription = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ThreadDeathEvent).subscribe(debugEvent -> {
            ThreadReference deathThread = ((ThreadDeathEvent)debugEvent.event).thread();
            this.compiledExpressions.remove(deathThread.uniqueID());
        });
        super.subscriptions().add(subscription);
        return super.install();
    }
}

