/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.google.gson.JsonElement;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.sun.jdi.event.Event;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UsageDataSession {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static final Logger usageDataLogger = Logger.getLogger("java-debug-usage-data");
    private static final long RESPONSE_MAX_DELAY_MS = 1000L;
    private static final ThreadLocal<UsageDataSession> threadLocal = new InheritableThreadLocal<UsageDataSession>();
    private static final boolean TRACE_DAP_PERF = Boolean.getBoolean("debug.dap.perf");
    private final String sessionGuid = UUID.randomUUID().toString();
    private boolean jdiEventSequenceEnabled = false;
    private long startAt = -1L;
    private long stopAt = -1L;
    private Map<String, Integer> commandCountMap = new HashMap<String, Integer>();
    private Map<String, Integer> breakpointCountMap = new HashMap<String, Integer>();
    private Map<Integer, RequestEvent> requestEventMap = new HashMap<Integer, RequestEvent>();
    private Map<String, Integer> userErrorCount = new HashMap<String, Integer>();
    private Map<String, Integer> commandPerfCountMap = new HashMap<String, Integer>();
    private List<String> eventList = new ArrayList<String>();
    private List<String[]> dapPerf = new ArrayList<String[]>();

    public static String getSessionGuid() {
        return threadLocal.get() == null ? "" : UsageDataSession.threadLocal.get().sessionGuid;
    }

    public UsageDataSession() {
        threadLocal.set(this);
    }

    public void reportStart() {
        this.startAt = System.currentTimeMillis();
    }

    public void reportStop() {
        this.stopAt = System.currentTimeMillis();
    }

    public void recordRequest(Messages.Request request) {
        try {
            this.requestEventMap.put(request.seq, new RequestEvent(request, System.currentTimeMillis()));
            this.commandCountMap.put(request.command, this.commandCountMap.getOrDefault(request.command, 0) + 1);
            if ("setBreakpoints".equals(request.command)) {
                String fileIdentifier = "unknown file";
                JsonElement pathElement = request.arguments.get("source").getAsJsonObject().get("path");
                JsonElement nameElement = request.arguments.get("source").getAsJsonObject().get("name");
                if (pathElement != null) {
                    fileIdentifier = pathElement.getAsString();
                } else if (nameElement != null) {
                    fileIdentifier = nameElement.getAsString();
                }
                String filenameHash = AdapterUtils.getSHA256HexDigest(fileIdentifier);
                int bpCount = request.arguments.get("breakpoints").getAsJsonArray().size();
                this.breakpointCountMap.put(filenameHash, this.breakpointCountMap.getOrDefault(filenameHash, 0) + bpCount);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordResponse(Messages.Response response) {
        try {
            long responseMillis;
            long requestMillis = responseMillis = System.currentTimeMillis();
            String command = null;
            RequestEvent requestEvent = this.requestEventMap.getOrDefault(response.request_seq, null);
            if (requestEvent != null) {
                command = requestEvent.request.command;
                requestMillis = requestEvent.timestamp;
                this.requestEventMap.remove(response.request_seq);
            }
            long duration = responseMillis - requestMillis;
            this.commandPerfCountMap.compute(command, (k, v) -> (v == null ? 0 : v) + (int)duration);
            if (TRACE_DAP_PERF) {
                List<String[]> list = this.dapPerf;
                synchronized (list) {
                    this.dapPerf.add(new String[]{command, String.valueOf(duration)});
                }
            }
            if (!response.success || duration > 1000L) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("duration", duration);
                props.put("command", command);
                props.put("success", response.success);
                usageDataLogger.log(Level.WARNING, "abnormal response", props);
                this.jdiEventSequenceEnabled = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitUsageData() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sessionStartAt", String.valueOf(this.startAt));
        props.put("sessionStopAt", String.valueOf(this.stopAt));
        props.put("commandCount", JsonUtils.toJson(this.commandCountMap));
        props.put("breakpointCount", JsonUtils.toJson(this.breakpointCountMap));
        props.put("userErrorCount", JsonUtils.toJson(this.userErrorCount));
        props.put("commandPerfCount", JsonUtils.toJson(this.commandPerfCountMap));
        if (this.jdiEventSequenceEnabled) {
            List<String> list = this.eventList;
            synchronized (list) {
                props.put("jdiEventSequence", JsonUtils.toJson(this.eventList));
            }
        }
        usageDataLogger.log(Level.INFO, "session usage data summary", props);
        if (TRACE_DAP_PERF) {
            Formatter fmt = new Formatter();
            fmt.format("\nDAP Performance Metrics:\n", new Object[0]);
            fmt.format("%30s %10s(ms)\n", "Request", "Duration");
            List<String[]> list = this.dapPerf;
            synchronized (list) {
                this.dapPerf.forEach(event -> fmt.format("%30s %14s\n", event[0], event[1]));
            }
            logger.info(String.valueOf(fmt));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordEvent(Event event) {
        block5: {
            try {
                UsageDataSession currentSession = threadLocal.get();
                if (currentSession == null) break block5;
                HashMap<String, String> eventEntry = new HashMap<String, String>();
                eventEntry.put("timestamp", String.valueOf(System.currentTimeMillis()));
                eventEntry.put("event", event.toString());
                List<String> list = currentSession.eventList;
                synchronized (list) {
                    currentSession.eventList.add(JsonUtils.toJson(eventEntry));
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Exception on recording event: %s.", e.toString()), e);
            }
        }
    }

    public static void recordInfo(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        usageDataLogger.log(Level.INFO, "session info", map);
    }

    public static void recordInfo(String description, Map<String, Object> data) {
        usageDataLogger.log(Level.INFO, description, data);
    }

    public void recordUserError(ErrorCode errorCode) {
        try {
            String errorCodeStr = errorCode.name();
            this.userErrorCount.put(errorCodeStr, this.userErrorCount.getOrDefault(errorCodeStr, 0) + 1);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, String.format("Exception on recording user error: %s.", e.toString()), e);
        }
    }

    public static void enableJdiEventSequence() {
        try {
            UsageDataSession currentSession = threadLocal.get();
            if (currentSession != null) {
                currentSession.jdiEventSequenceEnabled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class RequestEvent {
        Messages.Request request;
        long timestamp;

        RequestEvent(Messages.Request request, long timestamp) {
            this.request = request;
            this.timestamp = timestamp;
        }
    }
}

