/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.formatter;

import com.microsoft.java.debug.core.adapter.formatter.IValueFormatter;
import com.microsoft.java.debug.core.adapter.formatter.NumericFormatter;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Map;
import java.util.function.BiFunction;

public class ObjectFormatter
implements IValueFormatter {
    protected final BiFunction<Type, Map<String, Object>, String> typeToStringFunction;

    public ObjectFormatter(BiFunction<Type, Map<String, Object>, String> typeToStringFunction) {
        this.typeToStringFunction = typeToStringFunction;
    }

    @Override
    public String toString(Object obj, Map<String, Object> options) {
        return String.format("%s %s", this.getPrefix((ObjectReference)obj, options), ObjectFormatter.getIdPostfix((ObjectReference)obj, options));
    }

    @Override
    public boolean acceptType(Type type, Map<String, Object> options) {
        if (type == null) {
            return false;
        }
        char tag = type.signature().charAt(0);
        return tag == 'L' || tag == '[' || tag == 's' || tag == 't' || tag == 'g' || tag == 'l' || tag == 'c';
    }

    @Override
    public Value valueOf(String value, Type type, Map<String, Object> options) {
        if (value == null || "null".equals(value)) {
            return null;
        }
        throw new UnsupportedOperationException(String.format("Set value is not supported yet for type %s.", type.name()));
    }

    protected String getPrefix(ObjectReference value, Map<String, Object> options) {
        return this.typeToStringFunction.apply(value.type(), options);
    }

    protected static String getIdPostfix(ObjectReference obj, Map<String, Object> options) {
        return String.format("(id=%s)", NumericFormatter.formatNumber(obj.uniqueID(), options));
    }
}

