/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Types;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class InitializeRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.INITIALIZE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments argument, Messages.Response response, IDebugAdapterContext context) {
        Requests.InitializeArguments initializeArguments = (Requests.InitializeArguments)argument;
        context.setClientLinesStartAt1(initializeArguments.linesStartAt1);
        String pathFormat = initializeArguments.pathFormat;
        if (pathFormat != null) {
            switch (pathFormat) {
                case "uri": {
                    context.setClientPathsAreUri(true);
                    break;
                }
                default: {
                    context.setClientPathsAreUri(false);
                }
            }
        }
        context.setSupportsRunInTerminalRequest(initializeArguments.supportsRunInTerminalRequest);
        Types.Capabilities caps = new Types.Capabilities();
        caps.supportsConfigurationDoneRequest = true;
        caps.supportsHitConditionalBreakpoints = true;
        caps.supportsConditionalBreakpoints = true;
        caps.supportsSetVariable = true;
        caps.supportTerminateDebuggee = true;
        Types.ExceptionBreakpointFilter[] exceptionFilters = new Types.ExceptionBreakpointFilter[]{Types.ExceptionBreakpointFilter.UNCAUGHT_EXCEPTION_FILTER, Types.ExceptionBreakpointFilter.CAUGHT_EXCEPTION_FILTER};
        caps.exceptionBreakpointFilters = exceptionFilters;
        response.body = caps;
        return CompletableFuture.completedFuture(response);
    }
}

