/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.google.gson.JsonObject;
import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.DebugSession;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.ICompletionsProvider;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.IVirtualMachineManagerProvider;
import com.microsoft.java.debug.core.adapter.ProcessConsole;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class LaunchRequestHandler
implements IDebugRequestHandler {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static final long RUNINTERMINAL_TIMEOUT = 10000L;
    private static final int ACCEPT_TIMEOUT = 10000;
    private static final String TERMINAL_TITLE = "Java Debug Console";

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.LAUNCH);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.LaunchArguments launchArguments = (Requests.LaunchArguments)arguments;
        if (StringUtils.isBlank((CharSequence)launchArguments.mainClass) || ArrayUtils.isEmpty((Object[])launchArguments.modulePaths) && ArrayUtils.isEmpty((Object[])launchArguments.classPaths)) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.ARGUMENT_MISSING, String.format("Failed to launch debuggee VM. Missing mainClass or modulePaths/classPaths options in launch configuration", new Object[0]));
        }
        context.setAttached(false);
        context.setSourcePaths(launchArguments.sourcePaths);
        context.setVmStopOnEntry(launchArguments.stopOnEntry);
        context.setMainClass(LaunchRequestHandler.parseMainClassWithoutModuleName(launchArguments.mainClass));
        context.setStepFilters(launchArguments.stepFilters);
        if (StringUtils.isBlank((CharSequence)launchArguments.encoding)) {
            context.setDebuggeeEncoding(StandardCharsets.UTF_8);
        } else {
            if (!Charset.isSupported(launchArguments.encoding)) {
                return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.INVALID_ENCODING, String.format("Failed to launch debuggee VM. 'encoding' options in the launch configuration is not recognized.", new Object[0]));
            }
            context.setDebuggeeEncoding(Charset.forName(launchArguments.encoding));
        }
        launchArguments.vmArgs = StringUtils.isBlank((CharSequence)launchArguments.vmArgs) ? String.format("-Dfile.encoding=%s", context.getDebuggeeEncoding().name()) : String.format("%s -Dfile.encoding=%s", launchArguments.vmArgs, context.getDebuggeeEncoding().name());
        return this.launch(launchArguments, response, context).thenCompose(res -> {
            if (res.success) {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("debuggeeEncoding", context.getDebuggeeEncoding());
                if (launchArguments.projectName != null) {
                    options.put("projectName", launchArguments.projectName);
                }
                if (launchArguments.mainClass != null) {
                    options.put("mainClass", launchArguments.mainClass);
                }
                ISourceLookUpProvider sourceProvider = context.getProvider(ISourceLookUpProvider.class);
                sourceProvider.initialize(context, options);
                IEvaluationProvider evaluationProvider = context.getProvider(IEvaluationProvider.class);
                evaluationProvider.initialize(context, options);
                IHotCodeReplaceProvider hcrProvider = context.getProvider(IHotCodeReplaceProvider.class);
                hcrProvider.initialize(context, options);
                ICompletionsProvider completionsProvider = context.getProvider(ICompletionsProvider.class);
                completionsProvider.initialize(context, options);
                context.getProtocolServer().sendEvent(new Events.InitializedEvent());
            }
            return CompletableFuture.completedFuture(res);
        });
    }

    private CompletableFuture<Messages.Response> launch(Requests.LaunchArguments launchArguments, Messages.Response response, IDebugAdapterContext context) {
        logger.info("Trying to launch Java Program with options:\n" + String.format("main-class: %s\n", launchArguments.mainClass) + String.format("args: %s\n", launchArguments.args) + String.format("module-path: %s\n", StringUtils.join((Object[])launchArguments.modulePaths, (String)File.pathSeparator)) + String.format("class-path: %s\n", StringUtils.join((Object[])launchArguments.classPaths, (String)File.pathSeparator)) + String.format("vmArgs: %s", launchArguments.vmArgs));
        if (context.supportsRunInTerminalRequest() && (launchArguments.console == Requests.CONSOLE.integratedTerminal || launchArguments.console == Requests.CONSOLE.externalTerminal)) {
            return this.launchInTerminal(launchArguments, response, context);
        }
        return this.launchInternally(launchArguments, response, context);
    }

    private CompletableFuture<Messages.Response> launchInTerminal(Requests.LaunchArguments launchArguments, Messages.Response response, IDebugAdapterContext context) {
        CompletableFuture<Messages.Response> resultFuture = new CompletableFuture<Messages.Response>();
        IVirtualMachineManagerProvider vmProvider = context.getProvider(IVirtualMachineManagerProvider.class);
        String launchInTerminalErrorFormat = "Failed to launch debuggee in terminal. Reason: %s";
        try {
            List<ListeningConnector> connectors = vmProvider.getVirtualMachineManager().listeningConnectors();
            ListeningConnector listenConnector = connectors.get(0);
            Map<String, Connector.Argument> args = listenConnector.defaultArguments();
            ((Connector.IntegerArgument)args.get("timeout")).setValue(10000);
            String address = listenConnector.startListening(args);
            String[] cmds = this.constructLaunchCommands(launchArguments, false, address);
            Requests.RunInTerminalRequestArguments requestArgs = null;
            requestArgs = launchArguments.console == Requests.CONSOLE.integratedTerminal ? Requests.RunInTerminalRequestArguments.createIntegratedTerminal(cmds, launchArguments.cwd, launchArguments.env, TERMINAL_TITLE) : Requests.RunInTerminalRequestArguments.createExternalTerminal(cmds, launchArguments.cwd, launchArguments.env, TERMINAL_TITLE);
            Messages.Request request = new Messages.Request(Requests.Command.RUNINTERMINAL.getName(), (JsonObject)JsonUtils.toJsonTree(requestArgs, Requests.RunInTerminalRequestArguments.class));
            context.getProtocolServer().sendRequest(request, 10000L).whenComplete((runResponse, ex) -> {
                if (runResponse != null) {
                    if (runResponse.success) {
                        try {
                            VirtualMachine vm = listenConnector.accept(args);
                            context.setDebugSession(new DebugSession(vm));
                            logger.info("Launching debuggee in terminal console succeeded.");
                            resultFuture.complete(response);
                        }
                        catch (IllegalConnectorArgumentsException | IOException e) {
                            logger.log(Level.SEVERE, String.format("Failed to launch debuggee in terminal. Reason: %s", e.toString()));
                            resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", e.toString()), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                        }
                    } else {
                        logger.log(Level.SEVERE, String.format("Failed to launch debuggee in terminal. Reason: %s", runResponse.message));
                        resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", runResponse.message), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                    }
                } else {
                    if (ex instanceof CompletionException && ex.getCause() != null) {
                        ex = ex.getCause();
                    }
                    String errorMessage = String.format("Failed to launch debuggee in terminal. Reason: %s", ex != null ? ex.toString() : "Null response");
                    logger.log(Level.SEVERE, errorMessage);
                    resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", errorMessage), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                }
            });
        }
        catch (IllegalConnectorArgumentsException | IOException e) {
            logger.log(Level.SEVERE, String.format("Failed to launch debuggee in terminal. Reason: %s", e.toString()));
            resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", e.toString()), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
        }
        return resultFuture;
    }

    private CompletableFuture<Messages.Response> launchInternally(Requests.LaunchArguments launchArguments, Messages.Response response, IDebugAdapterContext context) {
        CompletableFuture<Messages.Response> resultFuture = new CompletableFuture<Messages.Response>();
        String[] envVars = null;
        if (launchArguments.env != null && !launchArguments.env.isEmpty()) {
            HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
            ArrayList<String> duplicated = new ArrayList<String>();
            for (Map.Entry<String, String> entry : launchArguments.env.entrySet()) {
                if (environment.containsKey(entry.getKey())) {
                    duplicated.add(entry.getKey());
                }
                environment.put(entry.getKey(), entry.getValue());
            }
            if (!duplicated.isEmpty()) {
                logger.warning(String.format("There are duplicated environment variables. The values specified in launch.json will be used. Here are the duplicated entries: %s.", String.join((CharSequence)",", duplicated)));
            }
            envVars = new String[environment.size()];
            int i = 0;
            for (Map.Entry entry : environment.entrySet()) {
                envVars[i++] = (String)entry.getKey() + "=" + (String)entry.getValue();
            }
        }
        try {
            IVirtualMachineManagerProvider vmProvider = context.getProvider(IVirtualMachineManagerProvider.class);
            IDebugSession debugSession = DebugUtility.launch(vmProvider.getVirtualMachineManager(), launchArguments.mainClass, launchArguments.args, launchArguments.vmArgs, Arrays.asList(launchArguments.modulePaths), Arrays.asList(launchArguments.classPaths), launchArguments.cwd, envVars);
            context.setDebugSession(debugSession);
            logger.info("Launching debuggee VM succeeded.");
            ProcessConsole debuggeeConsole = new ProcessConsole(debugSession.process(), "Debuggee", context.getDebuggeeEncoding());
            debuggeeConsole.onStdout((Consumer<String>)((Consumer)output -> context.getProtocolServer().sendEvent(Events.OutputEvent.createStdoutOutput(output))));
            debuggeeConsole.onStderr((Consumer<String>)((Consumer)err -> context.getProtocolServer().sendEvent(Events.OutputEvent.createStderrOutput(err))));
            debuggeeConsole.start();
            resultFuture.complete(response);
        }
        catch (IllegalConnectorArgumentsException | VMStartException | IOException e) {
            logger.log(Level.SEVERE, String.format("Failed to launch debuggee VM. Reason: %s", e.toString()));
            resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee VM. Reason: %s", e.toString()), ErrorCode.LAUNCH_FAILURE.getId()));
        }
        return resultFuture;
    }

    private static String parseMainClassWithoutModuleName(String mainClass) {
        int index = mainClass.indexOf(47);
        return mainClass.substring(index + 1);
    }

    private String[] constructLaunchCommands(Requests.LaunchArguments launchArguments, boolean serverMode, String address) {
        String slash = System.getProperty("file.separator");
        ArrayList<String> launchCmds = new ArrayList<String>();
        launchCmds.add(System.getProperty("java.home") + slash + "bin" + slash + "java");
        launchCmds.add(String.format("-agentlib:jdwp=transport=dt_socket,server=%s,suspend=y,address=%s", serverMode ? "y" : "n", address));
        if (StringUtils.isNotBlank((CharSequence)launchArguments.vmArgs)) {
            launchCmds.addAll(LaunchRequestHandler.parseArguments(launchArguments.vmArgs));
        }
        if (ArrayUtils.isNotEmpty((Object[])launchArguments.modulePaths)) {
            launchCmds.add("--module-path");
            launchCmds.add(String.join((CharSequence)File.pathSeparator, launchArguments.modulePaths));
        }
        if (ArrayUtils.isNotEmpty((Object[])launchArguments.classPaths)) {
            launchCmds.add("-cp");
            launchCmds.add(String.join((CharSequence)File.pathSeparator, launchArguments.classPaths));
        }
        String[] mainClasses = launchArguments.mainClass.split("/");
        if (ArrayUtils.isNotEmpty((Object[])launchArguments.modulePaths) || mainClasses.length == 2) {
            launchCmds.add("-m");
        }
        launchCmds.add(launchArguments.mainClass);
        if (StringUtils.isNotBlank((CharSequence)launchArguments.args)) {
            launchCmds.addAll(LaunchRequestHandler.parseArguments(launchArguments.args));
        }
        return launchCmds.toArray(new String[0]);
    }

    private static List<String> parseArguments(String cmdStr) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(cmdStr);
        while (m.find()) {
            String arg = m.group(1).replaceAll("^\"|\"$", "");
            list.add(arg);
        }
        return list;
    }
}

