/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.protocol;

import java.nio.file.Paths;

public class Types {

    public static class Capabilities {
        public boolean supportsConfigurationDoneRequest;
        public boolean supportsHitConditionalBreakpoints;
        public boolean supportsConditionalBreakpoints;
        public boolean supportsEvaluateForHovers;
        public boolean supportsCompletionsRequest;
        public boolean supportsRestartFrame;
        public boolean supportsSetVariable;
        public boolean supportsRestartRequest;
        public boolean supportTerminateDebuggee;
        public boolean supportsDelayedStackTraceLoading;
        public ExceptionBreakpointFilter[] exceptionBreakpointFilters = new ExceptionBreakpointFilter[0];
    }

    public static class ExceptionBreakpointFilter {
        public static final String UNCAUGHT_EXCEPTION_FILTER_NAME = "uncaught";
        public static final String CAUGHT_EXCEPTION_FILTER_NAME = "caught";
        public static final String UNCAUGHT_EXCEPTION_FILTER_LABEL = "Uncaught Exceptions";
        public static final String CAUGHT_EXCEPTION_FILTER_LABEL = "Caught Exceptions";
        public String label;
        public String filter;
        public static final ExceptionBreakpointFilter UNCAUGHT_EXCEPTION_FILTER = new ExceptionBreakpointFilter("uncaught", "Uncaught Exceptions");
        public static final ExceptionBreakpointFilter CAUGHT_EXCEPTION_FILTER = new ExceptionBreakpointFilter("caught", "Caught Exceptions");

        public ExceptionBreakpointFilter(String value, String label) {
            this.filter = value;
            this.label = label;
        }
    }

    public static class CompletionItem {
        public String label;
        public String text;
        public String type;
        public int start;
        public int number;

        public CompletionItem() {
        }

        public CompletionItem(String label, String text) {
            this.label = label;
            this.text = text;
        }
    }

    public static class FunctionBreakpoint {
        public String name;
        public String condition;
        public String hitCondition;

        public FunctionBreakpoint() {
        }

        public FunctionBreakpoint(String name) {
            this.name = name;
        }
    }

    public static class SourceBreakpoint {
        public int line;
        public String hitCondition;
        public String condition;

        public SourceBreakpoint() {
        }

        public SourceBreakpoint(int line, String condition, String hitCondition) {
            this.line = line;
            this.condition = condition;
            this.hitCondition = hitCondition;
        }
    }

    public static class Breakpoint {
        public int id;
        public boolean verified;
        public int line;
        public String message;

        public Breakpoint(int id, boolean verified, int line, String message) {
            this.id = id;
            this.verified = verified;
            this.line = line;
            this.message = message;
        }
    }

    public static class Source {
        public String name;
        public String path;
        public int sourceReference;

        public Source() {
        }

        public Source(String name, String path, int rf) {
            this.name = name;
            this.path = path;
            this.sourceReference = rf;
        }

        public Source(String path, int rf) {
            this.name = Paths.get(path, new String[0]).getFileName().toString();
            this.path = path;
            this.sourceReference = rf;
        }
    }

    public static class Thread {
        public long id;
        public String name;

        public Thread(long l, String name) {
            this.id = l;
            this.name = name == null || name.length() == 0 ? String.format("Thread #%d", l) : name;
        }
    }

    public static class Variable {
        public String name;
        public String value;
        public String type;
        public int variablesReference;
        public int indexedVariables;
        public String evaluateName;

        public Variable(String name, String val, String type, int rf, String evaluateName) {
            this.name = name;
            this.value = val;
            this.type = type;
            this.variablesReference = rf;
            this.evaluateName = evaluateName;
        }
    }

    public static class Scope {
        public String name;
        public int variablesReference;
        public boolean expensive;

        public Scope(String name, int rf, boolean exp) {
            this.name = name;
            this.variablesReference = rf;
            this.expensive = exp;
        }
    }

    public static class StackFrame {
        public int id;
        public Source source;
        public int line;
        public int column;
        public String name;

        public StackFrame(int id, String name, Source src, int ln, int col) {
            this.id = id;
            this.name = name;
            this.source = src;
            this.line = ln;
            this.column = col;
        }
    }

    public static class Message {
        public int id;
        public String format;

        public Message(int id, String format) {
            this.id = id;
            this.format = format;
        }
    }
}

