/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.plugin.internal.JdtUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;

public class ResolveMainClassHandler {
    private static final Logger logger = Logger.getLogger("java-debug");

    public Object resolveMainClass(List<Object> arguments) throws CoreException {
        return this.resolveMainClassCore(arguments);
    }

    private List<ResolutionItem> resolveMainClassCore(List<Object> arguments) throws CoreException {
        IPath rootPath = null;
        if (arguments != null && arguments.size() > 0) {
            rootPath = ResourceUtils.filePathFromURI((String)((String)arguments.get(0)));
        }
        final ArrayList<IPath> targetProjectPath = new ArrayList<IPath>();
        if (rootPath != null) {
            targetProjectPath.add(rootPath);
        }
        IJavaSearchScope searchScope = SearchEngine.createWorkspaceScope();
        SearchPattern pattern = SearchPattern.createPattern((String)"main(String[]) void", (int)1, (int)0, (int)8);
        final ArrayList res = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                block7: {
                    Object element = match.getElement();
                    if (element instanceof IMethod) {
                        IMethod method = (IMethod)element;
                        try {
                            String projectName;
                            String moduleName;
                            IProject project;
                            IResource resource;
                            if (!method.isMainMethod() || (resource = method.getResource()) == null || (project = resource.getProject()) == null) break block7;
                            String mainClass = method.getDeclaringType().getFullyQualifiedName();
                            IJavaProject javaProject = JdtUtils.getJavaProject(project);
                            if (javaProject != null && (moduleName = JdtUtils.getModuleName(javaProject)) != null) {
                                mainClass = String.valueOf(moduleName) + "/" + mainClass;
                            }
                            String string = projectName = "jdt.ls-java-project".equals(project.getName()) ? null : project.getName();
                            if (projectName != null && !targetProjectPath.isEmpty() && !ResourceUtils.isContainedIn((IPath)project.getLocation(), (Collection)targetProjectPath)) break block7;
                            String filePath = null;
                            if (match.getResource() instanceof IFile) {
                                try {
                                    filePath = match.getResource().getLocation().toOSString();
                                }
                                catch (Exception exception) {}
                            }
                            res.add(new ResolutionItem(mainClass, projectName, filePath));
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                }
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        try {
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, requestor, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, String.format("Searching the main class failure: %s", e.toString()), e);
        }
        return res.stream().distinct().collect(Collectors.toList());
    }

    private class ResolutionItem {
        private String mainClass;
        private String projectName;
        private String filePath;

        public ResolutionItem(String mainClass, String projectName, String filePath) {
            this.mainClass = mainClass;
            this.projectName = projectName;
            this.filePath = filePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ResolutionItem) {
                ResolutionItem item = (ResolutionItem)o;
                return Objects.equals(this.mainClass, item.mainClass) && Objects.equals(this.projectName, item.projectName) && Objects.equals(this.filePath, item.filePath);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.mainClass, this.projectName, this.filePath);
        }
    }
}

