/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.plugin.internal.JdtUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.lsp4j.Range;

public class ResolveMainMethodHandler {
    public static Object resolveMainMethods(List<Object> arguments) throws DebugException {
        if (arguments == null || arguments.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Job.getJobManager().join((Object)"DocumentLifeCycleJobs", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException interruptedException) {}
        String uri = (String)arguments.get(0);
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)uri);
        if (unit == null || unit.getResource() == null || !unit.getResource().exists()) {
            return Collections.emptyList();
        }
        try {
            return ResolveMainMethodHandler.resolveMainMethodCore(unit);
        }
        catch (Exception e) {
            throw new DebugException("Failed to resolve main method codeLens: " + e.getMessage(), (Throwable)e);
        }
    }

    private static List<MainMethod> resolveMainMethodCore(ICompilationUnit compilationUnit) throws JavaModelException {
        ArrayList<MainMethod> result = new ArrayList<MainMethod>();
        for (IMethod method : ResolveMainMethodHandler.searchMainMethods(compilationUnit)) {
            MainMethod mainMethod = ResolveMainMethodHandler.extractMainMethodInfo(compilationUnit, method);
            if (mainMethod == null) continue;
            result.add(mainMethod);
        }
        return result;
    }

    private static List<IMethod> searchMainMethods(ICompilationUnit compilationUnit) throws JavaModelException {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        for (IType type : ResolveMainMethodHandler.getPotentialMainClassTypes(compilationUnit)) {
            IMethod method = ResolveMainMethodHandler.getMainMethod(type);
            if (method == null) continue;
            result.add(method);
        }
        return result;
    }

    private static IMethod getMainMethod(IType type) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.isMainMethod()) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static List<IType> getPotentialMainClassTypes(ICompilationUnit compilationUnit) throws JavaModelException {
        ArrayList<IType> result = new ArrayList<IType>();
        IType[] topLevelTypes = compilationUnit.getTypes();
        result.addAll(Arrays.asList(topLevelTypes));
        IType[] iTypeArray = topLevelTypes;
        int n = topLevelTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.addAll(ResolveMainMethodHandler.getPotentialMainClassTypesInChildren(type));
            ++n2;
        }
        return result;
    }

    private static List<IType> getPotentialMainClassTypesInChildren(IType type) throws JavaModelException {
        IType[] children = type.getTypes();
        if (children.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IType> result = new ArrayList<IType>();
        IType[] iTypeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IType child = iTypeArray[n2];
            if (child.isClass() && Flags.isStatic((int)child.getFlags())) {
                result.add(child);
                result.addAll(ResolveMainMethodHandler.getPotentialMainClassTypesInChildren(child));
            }
            ++n2;
        }
        return result;
    }

    private static MainMethod extractMainMethodInfo(ICompilationUnit typeRoot, IMethod method) throws JavaModelException {
        IProject project;
        Range range = ResolveMainMethodHandler.getRange(typeRoot, (IJavaElement)method);
        IResource resource = typeRoot.getResource();
        if (resource != null && (project = resource.getProject()) != null) {
            String moduleName;
            String mainClass = method.getDeclaringType().getFullyQualifiedName();
            IJavaProject javaProject = JdtUtils.getJavaProject(project);
            if (javaProject != null && (moduleName = JdtUtils.getModuleName(javaProject)) != null) {
                mainClass = String.valueOf(moduleName) + "/" + mainClass;
            }
            String projectName = "jdt.ls-java-project".equals(project.getName()) ? null : project.getName();
            return new MainMethod(range, mainClass, projectName);
        }
        return null;
    }

    private static Range getRange(ICompilationUnit typeRoot, IJavaElement element) throws JavaModelException {
        ISourceRange r = ((ISourceReference)element).getNameRange();
        return JDTUtils.toRange((IOpenable)typeRoot, (int)r.getOffset(), (int)r.getLength());
    }

    static class MainMethod {
        private Range range;
        private String mainClass;
        private String projectName;

        public MainMethod(Range range, String mainClass, String projectName) {
            this.range = range;
            this.mainClass = mainClass;
            this.projectName = projectName;
        }
    }
}

