/*
 * Decompiled with CFR 0.152.
 */
package multiversx;

import java.io.ByteArrayOutputStream;
import multiversx.Exceptions;
import org.bitcoinj.core.Bech32;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

public class Address {
    static final String HRP = "erd";
    static final int PUBKEY_LENGTH = 32;
    static final int PUBKEY_STRING_LENGTH = 64;
    static final int BECH32_LENGTH = 62;
    static final String ZERO_PUBKEY_STRING = "0000000000000000000000000000000000000000000000000000000000000000";
    private final String valueHex;

    private Address(String valueHex) {
        this.valueHex = valueHex;
    }

    public static Address createZeroAddress() {
        return new Address(ZERO_PUBKEY_STRING);
    }

    public static Address fromBech32(String value) throws Exceptions.AddressException {
        Bech32.Bech32Data bech32Data;
        try {
            bech32Data = Bech32.decode((String)value);
        }
        catch (Exception e) {
            throw new Exceptions.CannotCreateBech32AddressException((Object)value);
        }
        if (!bech32Data.hrp.equals(HRP)) {
            throw new Exceptions.BadAddressHrpException();
        }
        byte[] decodedBytes = Address.convertBits(bech32Data.data, 5, 8, false);
        String hex = new String(Hex.encode((byte[])decodedBytes));
        return new Address(hex);
    }

    public static Address fromHex(String value) throws Exceptions.AddressException {
        if (value.length() != 64 || !Address.isValidHex(value)) {
            throw new Exceptions.CannotCreateAddressException((Object)value);
        }
        return new Address(value);
    }

    private static boolean isValidHex(String value) {
        try {
            Hex.decode((String)value);
            return true;
        }
        catch (DecoderException error) {
            return false;
        }
    }

    public String hex() {
        return this.valueHex;
    }

    public byte[] pubkey() {
        return Hex.decode((String)this.valueHex);
    }

    public String bech32() throws Exceptions.AddressException {
        byte[] pubkey = this.pubkey();
        return Bech32.encode((String)HRP, (byte[])Address.convertBits(pubkey, 8, 5, true));
    }

    public static boolean isValidBech32(String value) {
        try {
            Address.fromBech32(value);
            return true;
        }
        catch (Exceptions.AddressException error) {
            return false;
        }
    }

    public static byte[] convertBits(byte[] data, int fromBits, int toBits, boolean pad) throws Exceptions.AddressException {
        int acc = 0;
        int bits = 0;
        ByteArrayOutputStream ret = new ByteArrayOutputStream();
        int maxv = (1 << toBits) - 1;
        int maxAcc = (1 << fromBits + toBits - 1) - 1;
        for (byte value : data) {
            int valueAsInt = value & 0xFF;
            if (valueAsInt < 0 || valueAsInt >>> fromBits != 0) {
                throw new Exceptions.CannotConvertBitsException();
            }
            acc = (acc << fromBits | valueAsInt) & maxAcc;
            bits += fromBits;
            while (bits >= toBits) {
                ret.write(acc >>> (bits -= toBits) & maxv);
            }
        }
        if (pad) {
            if (bits > 0) {
                ret.write(acc << toBits - bits & maxv);
            }
        } else if (bits >= fromBits || (acc << toBits - bits & maxv) != 0) {
            throw new Exceptions.CannotConvertBitsException();
        }
        return ret.toByteArray();
    }
}

