/*
 * Decompiled with CFR 0.152.
 */
package multiversx;

import multiversx.Address;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.util.encoders.Hex;

public class MessageSigning {
    private static final String signerMessagePrefix = "\u0017Elrond Signed Message:\n";

    private MessageSigning() {
    }

    public static String sign(byte[] privateKey, byte[] msg) {
        Ed25519Signer signer = MessageSigning.createSignerWithPrivateKey(privateKey);
        byte[] message = MessageSigning.computeHashOnMessage(msg);
        signer.update(message, 0, message.length);
        byte[] signature = signer.generateSignature();
        byte[] hexSig = Hex.encode((byte[])signature);
        return new String(hexSig);
    }

    public static boolean verify(Address address, byte[] msg, String signature) {
        Ed25519Signer signer = MessageSigning.createSignerWithPublicKey(address.pubkey());
        byte[] message = MessageSigning.computeHashOnMessage(msg);
        byte[] sig = Hex.decode((String)signature);
        Ed25519PublicKeyParameters publicKeyParameters = new Ed25519PublicKeyParameters(address.pubkey(), 0);
        signer.init(false, (CipherParameters)publicKeyParameters);
        signer.update(message, 0, message.length);
        return signer.verifySignature(sig);
    }

    private static String composeMessage(byte[] msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(signerMessagePrefix);
        sb.append(msg.length);
        for (byte b : msg) {
            sb.append((char)b);
        }
        return sb.toString();
    }

    private static byte[] computeHashOnMessage(byte[] msg) {
        Keccak.DigestKeccak hasher = MessageSigning.createKeccakHasher();
        String message = MessageSigning.composeMessage(msg);
        byte[] messageBytes = message.getBytes();
        byte[] hash = hasher.digest(messageBytes);
        return hash;
    }

    private static Ed25519Signer createSignerWithPrivateKey(byte[] privateKey) {
        Ed25519Signer signer = new Ed25519Signer();
        Ed25519PrivateKeyParameters parameters = new Ed25519PrivateKeyParameters(privateKey, 0);
        signer.init(true, (CipherParameters)parameters);
        return signer;
    }

    private static Ed25519Signer createSignerWithPublicKey(byte[] publicKey) {
        Ed25519Signer signer = new Ed25519Signer();
        Ed25519PublicKeyParameters publicKeyParameters = new Ed25519PublicKeyParameters(publicKey, 0);
        signer.init(false, (CipherParameters)publicKeyParameters);
        return signer;
    }

    private static Keccak.DigestKeccak createKeccakHasher() {
        return new Keccak.Digest256();
    }
}

