/*
 * Decompiled with CFR 0.152.
 */
package multiversx;

import java.io.IOException;
import multiversx.Exceptions;
import multiversx.IProvider;
import multiversx.ProxyProvider;

public class NetworkConfig {
    private static final NetworkConfig defaultInstance = new NetworkConfig();
    private String chainID = "T";
    private int gasPerDataByte = 1500;
    private long minGasLimit = 50000L;
    private long minGasPrice = 1000000000L;
    private int minTransactionVersion = 1;

    public static NetworkConfig getDefault() {
        return defaultInstance;
    }

    public void sync(IProvider provider) throws IOException, Exceptions.ProxyRequestException {
        NetworkConfig fresh = provider.getNetworkConfig();
        this.assign(fresh);
    }

    private void assign(NetworkConfig other) {
        this.chainID = other.chainID;
        this.gasPerDataByte = other.gasPerDataByte;
        this.minGasLimit = other.minGasLimit;
        this.minGasPrice = other.minGasPrice;
        this.minTransactionVersion = other.minTransactionVersion;
    }

    public static NetworkConfig fromProviderPayload(ProxyProvider.PayloadOfGetNetworkConfig response) {
        NetworkConfig config = new NetworkConfig();
        config.chainID = response.chainID;
        config.gasPerDataByte = response.gasPerDataByte;
        config.minGasLimit = response.minGasLimit;
        config.minGasPrice = response.minGasPrice;
        config.minTransactionVersion = response.minTransactionVersion;
        return config;
    }

    public String getChainID() {
        return this.chainID;
    }

    public void setChainID(String chainID) {
        this.chainID = chainID;
    }

    public int getGasPerDataByte() {
        return this.gasPerDataByte;
    }

    public void setGasPerDataByte(int gasPerDataByte) {
        this.gasPerDataByte = gasPerDataByte;
    }

    public long getMinGasLimit() {
        return this.minGasLimit;
    }

    public void setMinGasLimit(long minGasLimit) {
        this.minGasLimit = minGasLimit;
    }

    public long getMinGasPrice() {
        return this.minGasPrice;
    }

    public void setMinGasPrice(long minGasPrice) {
        this.minGasPrice = minGasPrice;
    }

    public int getMinTransactionVersion() {
        return this.minTransactionVersion;
    }

    public void setMinTransactionVersion(int minTransactionVersion) {
        this.minTransactionVersion = minTransactionVersion;
    }
}

