/*
 * Decompiled with CFR 0.152.
 */
package multiversx;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import multiversx.AccountOnNetwork;
import multiversx.Address;
import multiversx.Exceptions;
import multiversx.IProvider;
import multiversx.NetworkConfig;
import multiversx.Transaction;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bouncycastle.util.encoders.Hex;

public class ProxyProvider
implements IProvider {
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final Gson gson = new Gson();
    private final String url;
    private final OkHttpClient httpClient;

    public ProxyProvider(String url) {
        this.url = url;
        this.httpClient = new OkHttpClient();
    }

    @Override
    public NetworkConfig getNetworkConfig() throws IOException, Exceptions.ProxyRequestException {
        String responseJson = this.doGet("network/config");
        ResponseOfGetNetworkConfig typedResponse = (ResponseOfGetNetworkConfig)gson.fromJson(responseJson, ResponseOfGetNetworkConfig.class);
        typedResponse.throwIfError();
        PayloadOfGetNetworkConfig payload = ((WrapperOfGetNetworkConfig)typedResponse.data).config;
        return NetworkConfig.fromProviderPayload(payload);
    }

    @Override
    public AccountOnNetwork getAccount(Address address) throws IOException, Exceptions.AddressException, Exceptions.ProxyRequestException {
        String responseJson = this.doGet(String.format("address/%s", address.bech32()));
        ResponseOfGetAccount typedResponse = (ResponseOfGetAccount)gson.fromJson(responseJson, ResponseOfGetAccount.class);
        typedResponse.throwIfError();
        PayloadOfGetAccount payload = ((WrapperOfGetAccount)typedResponse.data).account;
        return AccountOnNetwork.fromProviderPayload(payload);
    }

    public ESDTDataResponse getESDTData(Address address, String tokenIdentifier) throws IOException, Exceptions.AddressException {
        String hexTokenIdentifier = this.adjustTokenIdentifier(tokenIdentifier);
        String responseJson = this.doGet(String.format("accounts/%s/tokens/%s", address.bech32(), hexTokenIdentifier));
        ESDTDataResponse typedResponse = (ESDTDataResponse)gson.fromJson(responseJson, ESDTDataResponse.class);
        if (typedResponse == null || typedResponse.balance == null) {
            return ESDTDataResponse.empty();
        }
        return typedResponse;
    }

    public BigInteger getNFTBalance(Address address, String tokenIdentifier, long nonce) throws IOException, Exceptions.AddressException {
        String hexTokenIdentifier = this.adjustTokenIdentifier(tokenIdentifier);
        String nonceStr = Long.toString(nonce, 16);
        if (nonceStr.length() % 2 == 1) {
            nonceStr = "0" + nonceStr;
        }
        String nftID = String.format("%s-%s", hexTokenIdentifier, nonceStr);
        String responseJson = this.doGet(String.format("accounts/%s/nfts/%s", address.bech32(), nftID));
        NFTDataResponse typedResponse = (NFTDataResponse)gson.fromJson(responseJson, NFTDataResponse.class);
        if (typedResponse == null || typedResponse.balance == null) {
            return BigInteger.ZERO;
        }
        return typedResponse.balance;
    }

    private String adjustTokenIdentifier(String tokenIdentifier) {
        if (tokenIdentifier.contains("-")) {
            return tokenIdentifier;
        }
        byte[] decodedHex = Hex.decode((String)tokenIdentifier);
        return new String(decodedHex, StandardCharsets.UTF_8);
    }

    @Override
    public String sendTransaction(Transaction transaction) throws IOException, Exceptions.CannotSerializeTransactionException, Exceptions.ProxyRequestException {
        String requestJson = transaction.serialize();
        String responseJson = this.doPost("transaction/send", requestJson);
        ResponseOfSendTransaction typedResponse = (ResponseOfSendTransaction)gson.fromJson(responseJson, ResponseOfSendTransaction.class);
        typedResponse.throwIfError();
        PayloadOfSendTransactionResponse payload = (PayloadOfSendTransactionResponse)typedResponse.data;
        return payload.txHash;
    }

    private String doGet(String resourceUrl) throws IOException {
        String getUrl = String.format("%s/%s", this.url, resourceUrl);
        Request request = new Request.Builder().url(getUrl).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String responseJson;
            String string = responseJson = response.body().string();
            return string;
        }
    }

    private String doPost(String resourceUrl, String json) throws IOException {
        String postUrl = String.format("%s/%s", this.url, resourceUrl);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(postUrl).post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            String responseJson;
            String string = responseJson = response.body().string();
            return string;
        }
    }

    public static class PayloadOfSendTransactionResponse {
        @SerializedName(value="txHash")
        public String txHash;
    }

    public static class ResponseOfSendTransaction
    extends ResponseBase<PayloadOfSendTransactionResponse> {
    }

    public static class NFTDataResponse {
        @SerializedName(value="balance")
        public BigInteger balance;
    }

    public static class ESDTDataResponse {
        @SerializedName(value="name")
        public String name;
        @SerializedName(value="decimals")
        public Integer decimals;
        @SerializedName(value="owner")
        public String owner;
        @SerializedName(value="minted")
        public BigInteger minted;
        @SerializedName(value="balance")
        public BigInteger balance;
        @SerializedName(value="burnt")
        public BigInteger burnt;

        public static ESDTDataResponse empty() {
            ESDTDataResponse emptyResponse = new ESDTDataResponse();
            emptyResponse.decimals = 0;
            emptyResponse.minted = BigInteger.ZERO;
            emptyResponse.burnt = BigInteger.ZERO;
            emptyResponse.owner = "";
            emptyResponse.name = "";
            emptyResponse.balance = BigInteger.ZERO;
            return emptyResponse;
        }
    }

    public static class PayloadOfGetAccount {
        @SerializedName(value="nonce")
        public long nonce;
        @SerializedName(value="balance")
        public BigInteger balance;
    }

    public static class WrapperOfGetAccount {
        @SerializedName(value="account")
        public PayloadOfGetAccount account;
    }

    public static class ResponseOfGetAccount
    extends ResponseBase<WrapperOfGetAccount> {
    }

    public static class PayloadOfGetNetworkConfig {
        @SerializedName(value="erd_chain_id")
        public String chainID;
        @SerializedName(value="erd_gas_per_data_byte")
        public int gasPerDataByte;
        @SerializedName(value="erd_min_gas_limit")
        public long minGasLimit;
        @SerializedName(value="erd_min_gas_price")
        public long minGasPrice;
        @SerializedName(value="erd_min_transaction_version")
        public int minTransactionVersion;
    }

    public static class WrapperOfGetNetworkConfig {
        @SerializedName(value="config")
        public PayloadOfGetNetworkConfig config;
    }

    public static class ResponseOfGetNetworkConfig
    extends ResponseBase<WrapperOfGetNetworkConfig> {
    }

    public static class ResponseBase<T> {
        @SerializedName(value="data")
        public T data;
        @SerializedName(value="error")
        public String error;
        @SerializedName(value="code")
        public String code;

        public void throwIfError() throws Exceptions.ProxyRequestException {
            if (this.error != null && !this.error.isEmpty()) {
                throw new Exceptions.ProxyRequestException(this.error);
            }
            if (!"successful".equals(this.code)) {
                throw new Exceptions.ProxyRequestException(this.code);
            }
        }
    }
}

