/*
 * Decompiled with CFR 0.152.
 */
package multiversx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import multiversx.Exceptions;
import org.bitcoinj.crypto.MnemonicCode;
import org.bitcoinj.crypto.MnemonicException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.util.encoders.Hex;

public class Wallet {
    static final int DEFAULT_ENTROPY_BITS = 256;
    static final String BIP39_SALT_MODIFIER = "mnemonic";
    static final int BIP39_PBKDF2_ROUNDS = 2048;
    static final String BIP32_SEED_MODIFIER = "ed25519 seed";
    static final long[] DERIVATION_PATH = new long[]{44L, 508L, 0L, 0L, 0L};
    static final long HARDENED_OFFSET = Integer.MIN_VALUE;
    private final byte[] publicKey;
    private final byte[] privateKey;

    public Wallet(String privateKeyHex) {
        this(Hex.decode((String)privateKeyHex));
    }

    public Wallet(byte[] privateKey) {
        Ed25519PrivateKeyParameters privateKeyParameters = new Ed25519PrivateKeyParameters(privateKey, 0);
        Ed25519PublicKeyParameters publicKeyParameters = privateKeyParameters.generatePublicKey();
        this.publicKey = publicKeyParameters.getEncoded();
        this.privateKey = privateKey;
    }

    public static List<String> generateMnemonic() throws Exceptions.CannotGenerateMnemonicException {
        try {
            byte[] entropy = Wallet.generateEntropy();
            MnemonicCode mnemonicCode = new MnemonicCode();
            List mnemonic = mnemonicCode.toMnemonic(entropy);
            return mnemonic;
        }
        catch (IOException | MnemonicException.MnemonicLengthException error) {
            throw new Exceptions.CannotGenerateMnemonicException();
        }
    }

    private static byte[] generateEntropy() {
        SecureRandom random = new SecureRandom();
        byte[] entropy = new byte[32];
        random.nextBytes(entropy);
        return entropy;
    }

    public static Wallet deriveFromMnemonic(String mnemonic, long accountIndex) throws Exceptions.CannotDeriveKeysException {
        try {
            byte[] seed = Wallet.mnemonicToBip39Seed(mnemonic);
            byte[] privateKey = Wallet.bip39SeedToPrivateKey(seed, accountIndex);
            return new Wallet(privateKey);
        }
        catch (IOException error) {
            throw new Exceptions.CannotDeriveKeysException();
        }
    }

    private static byte[] mnemonicToBip39Seed(String mnemonic) {
        byte[] mnemonicBytes = mnemonic.getBytes(StandardCharsets.UTF_8);
        byte[] passphrase = BIP39_SALT_MODIFIER.getBytes(StandardCharsets.UTF_8);
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator((Digest)new SHA512Digest());
        generator.init(mnemonicBytes, passphrase, 2048);
        byte[] seed = ((KeyParameter)generator.generateDerivedParameters(512)).getKey();
        return seed;
    }

    private static byte[] bip39SeedToPrivateKey(byte[] seed, long accountIndex) throws IOException {
        KeyAndChainCode keyAndChainCode = Wallet.bip39SeedToMasterKey(seed);
        byte[] key = keyAndChainCode.key;
        byte[] chainCode = keyAndChainCode.chainCode;
        long[] derivationPath = Arrays.copyOf(DERIVATION_PATH, DERIVATION_PATH.length);
        derivationPath[derivationPath.length - 1] = accountIndex;
        for (long segment : derivationPath) {
            keyAndChainCode = Wallet.ckdPriv(key, chainCode, segment + Integer.MIN_VALUE);
            key = keyAndChainCode.key;
            chainCode = keyAndChainCode.chainCode;
        }
        return key;
    }

    private static KeyAndChainCode bip39SeedToMasterKey(byte[] seed) {
        byte[] result = Wallet.hmacSHA512(BIP32_SEED_MODIFIER.getBytes(StandardCharsets.UTF_8), seed);
        byte[] masterKey = Arrays.copyOfRange(result, 0, 32);
        byte[] chainCode = Arrays.copyOfRange(result, 32, 64);
        return new KeyAndChainCode(masterKey, chainCode);
    }

    private static KeyAndChainCode ckdPriv(byte[] key, byte[] chainCode, long index) throws IOException {
        ByteBuffer indexBuffer = ByteBuffer.allocate(4);
        indexBuffer.order(ByteOrder.BIG_ENDIAN);
        indexBuffer.putInt((int)(index & 0xFFFFFFFFL));
        byte[] indexBytes = indexBuffer.array();
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        dataStream.write(new byte[]{0});
        dataStream.write(key);
        dataStream.write(indexBytes);
        byte[] data = dataStream.toByteArray();
        byte[] result = Wallet.hmacSHA512(chainCode, data);
        return new KeyAndChainCode(Arrays.copyOfRange(result, 0, 32), Arrays.copyOfRange(result, 32, 64));
    }

    private static byte[] hmacSHA512(byte[] key, byte[] message) {
        byte[] result = new byte[64];
        HMac hmac = new HMac((Digest)new SHA512Digest());
        hmac.init((CipherParameters)new KeyParameter(key));
        hmac.update(message, 0, message.length);
        hmac.doFinal(result, 0);
        return result;
    }

    public String sign(String data) {
        return this.sign(data.getBytes(StandardCharsets.UTF_8));
    }

    public String sign(byte[] data) {
        Ed25519Signer signer = this.createEd25519Signer();
        signer.update(data, 0, data.length);
        byte[] signature = signer.generateSignature();
        byte[] hex = Hex.encode((byte[])signature);
        return new String(hex);
    }

    private Ed25519Signer createEd25519Signer() {
        Ed25519PrivateKeyParameters parameters = new Ed25519PrivateKeyParameters(this.privateKey, 0);
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(true, (CipherParameters)parameters);
        return signer;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    private static class KeyAndChainCode {
        public final byte[] key;
        public final byte[] chainCode;

        public KeyAndChainCode(byte[] key, byte[] chainCode) {
            this.key = key;
            this.chainCode = chainCode;
        }
    }
}

