/*
 * Decompiled with CFR 0.152.
 */
package multiversx.esdt;

import java.math.BigInteger;
import multiversx.Address;
import multiversx.Exceptions;
import multiversx.Transaction;
import multiversx.esdt.dtos.ESDTNFTTransferTypes;
import multiversx.esdt.dtos.ESDTTransferTypes;

public class ESDTFunctions {
    public static boolean isESDTTransfer(Transaction transaction) {
        return transaction.getData().startsWith("ESDTTransfer");
    }

    public static boolean isNFTTransfer(Transaction transaction) {
        return transaction.getData().startsWith("ESDTNFTTransfer");
    }

    public static ESDTTransferTypes extractESDTTransferTypes(Transaction transaction) throws Exceptions.InvalidESDTTransferPayload {
        if (!ESDTFunctions.isESDTTransfer(transaction)) {
            throw new Exceptions.InvalidESDTTransferPayload();
        }
        String payload = transaction.getData();
        String[] elements = payload.split("@");
        if (elements.length < 3) {
            throw new Exceptions.InvalidESDTTransferPayload();
        }
        String tokenIdentifier = elements[1];
        BigInteger valueToTransfer = ESDTFunctions.decodeHexEncodedBigInteger(elements[2]);
        return new ESDTTransferTypes(transaction.getSender(), transaction.getReceiver(), tokenIdentifier, valueToTransfer);
    }

    public static ESDTNFTTransferTypes extractESDTNFTTransferTypes(Transaction transaction) throws Exceptions.InvalidESDTNFTTransferPayload, Exceptions.AddressException {
        if (!ESDTFunctions.isNFTTransfer(transaction)) {
            throw new Exceptions.InvalidESDTNFTTransferPayload();
        }
        String payload = transaction.getData();
        String[] elements = payload.split("@");
        if (elements.length < 5) {
            throw new Exceptions.InvalidESDTNFTTransferPayload();
        }
        String tokenIdentifier = elements[1];
        long nonce = Long.parseLong(elements[2], 16);
        BigInteger valueToTransfer = ESDTFunctions.decodeHexEncodedBigInteger(elements[3]);
        Address receiver = Address.fromHex(elements[4]);
        return new ESDTNFTTransferTypes(transaction.getSender(), receiver, tokenIdentifier, valueToTransfer, nonce);
    }

    @Deprecated
    public static String constructESDTTransferPayload(ESDTTransferTypes types) {
        return "ESDTTransfer@" + types.getTokenIdentifier() + "@" + ESDTFunctions.prepareHexValue(types.getValueToTransfer().toString(16));
    }

    @Deprecated
    public static String constructNFTTransferPayload(ESDTNFTTransferTypes types) {
        return "ESDTNFTTransfer@" + types.getTokenIdentifier() + "@" + ESDTFunctions.prepareHexValue(Long.toString(types.getNonce(), 16)) + "@" + ESDTFunctions.prepareHexValue(types.getValueToTransfer().toString(16)) + "@" + types.getReceiver().hex();
    }

    private static BigInteger decodeHexEncodedBigInteger(String number) {
        return new BigInteger(number, 16);
    }

    private static String prepareHexValue(String value) {
        String result = value;
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        return result;
    }
}

