/*
 * Decompiled with CFR 0.152.
 */
package multiversx.esdt.builders;

import multiversx.Address;
import multiversx.esdt.common.TokenPayment;
import multiversx.esdt.common.Utils;

public class MultiTransferBuilder {
    private TokenPayment[] payments;
    private Address receiver;

    public MultiTransferBuilder setPayments(TokenPayment[] payments) {
        this.payments = payments;
        return this;
    }

    public MultiTransferBuilder setReceiver(Address receiver) {
        this.receiver = receiver;
        return this;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.join((CharSequence)"@", "MultiESDTNFTTransfer", this.receiver.hex()));
        String numTransfers = Utils.castToPaddedHex(this.payments.length);
        builder.append("@").append(numTransfers);
        for (TokenPayment payment : this.payments) {
            String nonceHex = Utils.castToPaddedHex(payment.getNonce());
            builder.append("@").append(String.join((CharSequence)"@", payment.getTokenIdentifier().toHexString(), nonceHex, payment.valueToHexString()));
        }
        return builder.toString();
    }
}

