/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.log;

import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.MDC;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

public final class LogFields {
    private LogFields() {
    }

    public static void validateLogFields(Map<String, LogField> knownFields, List<String> fields) {
        for (String fieldSpecifier : fields) {
            String[] chunks = StringUtils.split((String)fieldSpecifier, (String)":");
            String fieldKey = chunks[0];
            if (chunks.length > 2) {
                throw new IllegalArgumentException(String.format("Bad specifier \"%s\" has too many colons", fieldSpecifier));
            }
            if (knownFields.containsKey(fieldKey)) continue;
            throw new IllegalArgumentException(String.format("Invalid log pattern: unknown field <%s>", fieldSpecifier));
        }
    }

    public static class MDCField
    implements LogField {
        MDCField() {
        }

        @Override
        public Object log(Request request, Response response, String name) {
            return MDC.get((String)name);
        }

        @Override
        public String getShortName() {
            return "md";
        }
    }

    public static class TimestampField
    implements LogField {
        TimestampField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            return new DateTime(request.getTimeStamp(), DateTimeZone.UTC);
        }

        @Override
        public String getShortName() {
            return "ts";
        }
    }

    public static class ThreadNameField
    implements LogField {
        ThreadNameField() {
        }

        @Override
        public String log(Request request, Response response, String dummy) {
            return Thread.currentThread().getName();
        }

        @Override
        public String getShortName() {
            return "tn";
        }
    }

    public static class RequestDateHeaderField
    implements LogField {
        RequestDateHeaderField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            long dateValue = request.getDateHeader("Date");
            if (dateValue > 0L) {
                return dateValue;
            }
            return null;
        }

        @Override
        public String getShortName() {
            return "rd";
        }
    }

    public static class ResponseContentTypeField
    implements LogField {
        ResponseContentTypeField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            return response.getContentType();
        }

        @Override
        public String getShortName() {
            return "ru";
        }
    }

    public static class RequestContentTypeField
    implements LogField {
        RequestContentTypeField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            return request.getContentType();
        }

        @Override
        public String getShortName() {
            return "rt";
        }
    }

    public static class AttributeField
    implements LogField {
        AttributeField() {
        }

        @Override
        public Object log(Request request, Response response, String attribute) {
            return request.getAttribute(attribute);
        }

        @Override
        public String getShortName() {
            return "ra";
        }
    }

    public static class ResponseHeaderField
    implements LogField {
        ResponseHeaderField() {
        }

        @Override
        public Object log(Request request, Response response, String header) {
            if (StringUtils.trimToNull((String)header) == null) {
                return null;
            }
            return response.getHeader(header);
        }

        @Override
        public String getShortName() {
            return "rs";
        }
    }

    public static class RequestHeaderField
    implements LogField {
        RequestHeaderField() {
        }

        @Override
        public Object log(Request request, Response response, String header) {
            if (StringUtils.trimToNull((String)header) == null) {
                return null;
            }
            return request.getHeader(header);
        }

        @Override
        public String getShortName() {
            return "rh";
        }
    }

    public static class ResponseContentLengthField
    implements LogField {
        ResponseContentLengthField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            return response.getContentCount();
        }

        @Override
        public String getShortName() {
            return "cc";
        }
    }

    public static class RequestContentLengthField
    implements LogField {
        RequestContentLengthField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            return request.getContentLength();
        }

        @Override
        public String getShortName() {
            return "cl";
        }
    }

    public static class CookieField
    implements LogField {
        CookieField() {
        }

        @Override
        public Object log(Request request, Response response, String cookieName) {
            Cookie[] cookies = request.getCookies();
            if (StringUtils.trimToNull((String)cookieName) != null && cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookieName.equalsIgnoreCase(cookie.getName())) continue;
                    return cookie.getValue();
                }
            }
            return null;
        }

        @Override
        public String getShortName() {
            return "co";
        }
    }

    public static class QueryStringField
    implements LogField {
        QueryStringField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            return request.getQueryString();
        }

        @Override
        public String getShortName() {
            return "q";
        }
    }

    public static class ElapsedTimeField
    implements LogField {
        ElapsedTimeField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            DateTime start = new DateTime(request.getTimeStamp(), DateTimeZone.UTC);
            DateTime end = new DateTime(DateTimeZone.UTC);
            return new Duration((ReadableInstant)start, (ReadableInstant)end).getMillis();
        }

        @Override
        public String getShortName() {
            return "t";
        }
    }

    public static class ResponseCodeField
    implements LogField {
        ResponseCodeField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            return response.getStatus();
        }

        @Override
        public String getShortName() {
            return "rc";
        }
    }

    public static class RequestUriField
    implements LogField {
        RequestUriField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            return request.getRequestURL();
        }

        @Override
        public String getShortName() {
            return "u";
        }
    }

    public static class MethodField
    implements LogField {
        MethodField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            return request.getMethod();
        }

        @Override
        public String getShortName() {
            return "m";
        }
    }

    public static class RemoteAddrField
    implements LogField {
        RemoteAddrField() {
        }

        @Override
        public Object log(Request request, Response response, String dummy) {
            return request.getRemoteAddr();
        }

        @Override
        public String getShortName() {
            return "ip";
        }
    }

    public static interface LogField {
        public Object log(Request var1, Response var2, String var3);

        public String getShortName();
    }
}

