/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.jetty;

import com.google.inject.Singleton;
import com.nesscomputing.logging.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.http.gzip.AbstractCompressedStream;
import org.eclipse.jetty.http.gzip.CompressedResponseWrapper;

@Singleton
public class TransparentCompressionFilter
implements Filter {
    private static final Log LOG = Log.findLog();
    private static final String LZ4 = "lz4";
    private static final String GZIP = "gzip";
    private static final String DEFLATE = "deflate";
    protected Set<String> _mimeTypes;
    protected int _bufferSize = 8192;
    protected int _minGzipSize = 256;
    protected int _deflateCompressionLevel = -1;
    protected boolean _deflateNoWrap = true;
    protected Set<String> _excludedPaths;
    protected Set<Pattern> _excludedPathPatterns;

    public void init(FilterConfig filterConfig) throws ServletException {
        StringTokenizer tok;
        String tmp = filterConfig.getInitParameter("bufferSize");
        if (tmp != null) {
            this._bufferSize = Integer.parseInt(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("minGzipSize")) != null) {
            this._minGzipSize = Integer.parseInt(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("deflateCompressionLevel")) != null) {
            this._deflateCompressionLevel = Integer.parseInt(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("deflateNoWrap")) != null) {
            this._deflateNoWrap = Boolean.parseBoolean(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("mimeTypes")) != null) {
            this._mimeTypes = new HashSet<String>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._mimeTypes.add(tok.nextToken());
            }
        }
        if ((tmp = filterConfig.getInitParameter("excludePaths")) != null) {
            this._excludedPaths = new HashSet<String>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._excludedPaths.add(tok.nextToken());
            }
        }
        if ((tmp = filterConfig.getInitParameter("excludePathPatterns")) != null) {
            this._excludedPathPatterns = new HashSet<Pattern>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._excludedPathPatterns.add(Pattern.compile(tok.nextToken()));
            }
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String compressionType = this.selectCompression(request.getHeader("accept-encoding"));
        if (compressionType != null && !response.containsHeader("Content-Encoding") && !"HEAD".equalsIgnoreCase(request.getMethod())) {
            String requestURI = request.getRequestURI();
            if (this.isExcludedPath(requestURI)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            CompressedResponseWrapper wrappedResponse = this.createWrappedResponse(request, response, compressionType);
            boolean exceptional = true;
            try {
                chain.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse);
                exceptional = false;
            }
            finally {
                Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                if (continuation.isSuspended() && continuation.isResponseWrapped()) {
                    continuation.addContinuationListener((ContinuationListener)new ContinuationListenerWaitingForWrappedResponseToFinish(wrappedResponse));
                } else if (exceptional && !response.isCommitted()) {
                    wrappedResponse.resetBuffer();
                    wrappedResponse.noCompression();
                } else {
                    wrappedResponse.finish();
                }
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private String selectCompression(String encodingHeader) {
        if (encodingHeader != null) {
            if (encodingHeader.toLowerCase().contains(LZ4)) {
                return LZ4;
            }
            if (encodingHeader.toLowerCase().contains(GZIP)) {
                return GZIP;
            }
            if (encodingHeader.toLowerCase().contains(DEFLATE)) {
                return DEFLATE;
            }
        }
        return null;
    }

    protected CompressedResponseWrapper createWrappedResponse(HttpServletRequest request, HttpServletResponse response, final String compressionType) {
        CompressedResponseWrapper wrappedResponse = null;
        if (compressionType.equals(LZ4)) {
            wrappedResponse = new CompressedResponseWrapper(request, response){

                protected AbstractCompressedStream newCompressedStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minCompressSize) throws IOException {
                    return new AbstractCompressedStream(compressionType, request, response, contentLength, bufferSize, minCompressSize){

                        protected DeflaterOutputStream createStream() throws IOException {
                            return new DeflaterShim((OutputStream)new LZ4BlockOutputStream((OutputStream)this._response.getOutputStream(), this._bufferSize));
                        }
                    };
                }
            };
        } else if (compressionType.equals(GZIP)) {
            wrappedResponse = new CompressedResponseWrapper(request, response){

                protected AbstractCompressedStream newCompressedStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minCompressSize) throws IOException {
                    return new AbstractCompressedStream(compressionType, request, response, contentLength, bufferSize, minCompressSize){

                        protected DeflaterOutputStream createStream() throws IOException {
                            return new GZIPOutputStream((OutputStream)this._response.getOutputStream(), this._bufferSize);
                        }
                    };
                }
            };
        } else if (compressionType.equals(DEFLATE)) {
            wrappedResponse = new CompressedResponseWrapper(request, response){

                protected AbstractCompressedStream newCompressedStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minCompressSize) throws IOException {
                    return new AbstractCompressedStream(compressionType, request, response, contentLength, bufferSize, minCompressSize){

                        protected DeflaterOutputStream createStream() throws IOException {
                            return new DeflaterOutputStream((OutputStream)this._response.getOutputStream(), new Deflater(TransparentCompressionFilter.this._deflateCompressionLevel, TransparentCompressionFilter.this._deflateNoWrap));
                        }
                    };
                }
            };
        } else {
            throw new IllegalStateException(compressionType + " not supported");
        }
        this.configureWrappedResponse(wrappedResponse);
        return wrappedResponse;
    }

    protected void configureWrappedResponse(CompressedResponseWrapper wrappedResponse) {
        wrappedResponse.setMimeTypes(this._mimeTypes);
        wrappedResponse.setBufferSize(this._bufferSize);
        wrappedResponse.setMinCompressSize(this._minGzipSize);
    }

    private boolean isExcludedPath(String requestURI) {
        if (requestURI == null) {
            return false;
        }
        if (this._excludedPaths != null) {
            for (String excludedPath : this._excludedPaths) {
                if (!requestURI.startsWith(excludedPath)) continue;
                return true;
            }
        }
        if (this._excludedPathPatterns != null) {
            for (Pattern pattern : this._excludedPathPatterns) {
                if (!pattern.matcher(requestURI).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private static class DeflaterShim
    extends DeflaterOutputStream {
        DeflaterShim(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        protected void deflate() throws IOException {
            throw new UnsupportedOperationException("We don't want to deflate...");
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private static class ContinuationListenerWaitingForWrappedResponseToFinish
    implements ContinuationListener {
        private final CompressedResponseWrapper wrappedResponse;

        public ContinuationListenerWaitingForWrappedResponseToFinish(CompressedResponseWrapper wrappedResponse) {
            this.wrappedResponse = wrappedResponse;
        }

        public void onComplete(Continuation continuation) {
            try {
                this.wrappedResponse.finish();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        public void onTimeout(Continuation continuation) {
        }
    }
}

