/*
 * Decompiled with CFR 0.152.
 */
package com.evotext.clever;

import com.evotext.clever.model.Link;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.goebl.david.Webb;
import com.goebl.david.WebbException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class CleverClient {
    private String m_apiUrl = "https://api.clever.com";
    private String m_version = "v1.1";

    CleverClient() {
    }

    protected JSONObject get(String apiUrl, String oAuthToken, Map<String, Object> parameters) {
        Webb webb = Webb.create();
        webb.setDefaultHeader("Authorization", (Object)("Bearer " + oAuthToken));
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)webb.get(apiUrl).params(parameters).ensureSuccess().asJsonObject().getBody();
        }
        catch (WebbException we) {
            System.out.println("Error executing apiUrl: " + apiUrl + "  Error: " + we.getMessage());
            jsonObject = new JSONObject();
        }
        return jsonObject;
    }

    protected String getBaseUrl() {
        return this.m_apiUrl + "/" + this.m_version + "/";
    }

    protected String getApiUrl() {
        return this.m_apiUrl;
    }

    protected List<Link> getLinkList(JSONObject responseJSON) throws JSONException, JsonParseException, JsonMappingException, IOException {
        ArrayList<Link> linkList = new ArrayList<Link>();
        JSONArray dataJSON = responseJSON.getJSONArray("links");
        for (int i = 0; i < dataJSON.length(); ++i) {
            JSONObject joData = dataJSON.getJSONObject(i);
            String rel = joData.getString("rel");
            String uri = joData.getString("uri");
            Link link = new Link();
            link.setRel(rel);
            link.setUri(uri);
            linkList.add(link);
        }
        return linkList;
    }
}

