/*
 * Decompiled with CFR 0.152.
 */
package com.evotext.clever;

import com.evotext.clever.CleverClient;
import com.evotext.clever.model.SchoolAdmin;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class CleverSchoolAdminsClient
extends CleverClient {
    private String m_districtOAuthToken;

    public CleverSchoolAdminsClient(String districtOAuthToken) {
        this.m_districtOAuthToken = districtOAuthToken;
    }

    public SchoolAdmin getSchoolAdmin(String schoolAdminId) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("school_admins/" + schoolAdminId);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        JSONObject responseJSON = this.get(fullApiUrl.toString(), this.m_districtOAuthToken, parameters);
        ObjectMapper mapper = new ObjectMapper();
        SchoolAdmin objectValue = (SchoolAdmin)mapper.readValue(responseJSON.getString("data"), SchoolAdmin.class);
        return objectValue;
    }

    public BigInteger countSchoolAdmins() throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("school_admins");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("count", "true");
        JSONObject responseJSON = this.get(fullApiUrl.toString(), this.m_districtOAuthToken, parameters);
        String countValue = responseJSON.getString("count");
        BigInteger recordCount = new BigInteger(countValue);
        return recordCount;
    }

    public List<SchoolAdmin> getSchoolAdmins(int limit, String startingAfter, String endingBefore) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("school_admins");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("limit", limit);
        if (StringUtils.isNotEmpty((CharSequence)startingAfter)) {
            parameters.put("starting_after", startingAfter);
        }
        if (StringUtils.isNotEmpty((CharSequence)endingBefore)) {
            parameters.put("ending_before", endingBefore);
        }
        JSONObject responseJSON = this.get(fullApiUrl.toString(), this.m_districtOAuthToken, parameters);
        JSONArray dataJSON = responseJSON.getJSONArray("data");
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<SchoolAdmin> objectList = new ArrayList<SchoolAdmin>();
        for (int i = 0; i < dataJSON.length(); ++i) {
            JSONObject joData = dataJSON.getJSONObject(i);
            SchoolAdmin objectValue = (SchoolAdmin)mapper.readValue(joData.getString("data"), SchoolAdmin.class);
            objectList.add(objectValue);
        }
        return objectList;
    }

    public List<SchoolAdmin> getAllSchoolAdmins() throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("school_admins");
        ArrayList<SchoolAdmin> objectList = new ArrayList<SchoolAdmin>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("limit", 100);
        String uri = fullApiUrl.toString();
        boolean keepGoing = true;
        while (keepGoing) {
            int i;
            keepGoing = false;
            JSONObject responseJSON = this.get(uri, this.m_districtOAuthToken, parameters);
            ObjectMapper mapper = new ObjectMapper();
            JSONArray dataJSON = responseJSON.getJSONArray("data");
            JSONArray linksJSON = responseJSON.getJSONArray("links");
            for (i = 0; i < linksJSON.length(); ++i) {
                JSONObject linkData = linksJSON.getJSONObject(i);
                String relValue = linkData.getString("rel");
                if (!relValue.equalsIgnoreCase("next")) continue;
                String uriValue = linkData.getString("uri");
                keepGoing = true;
                uri = this.getApiUrl() + uriValue;
            }
            for (i = 0; i < dataJSON.length(); ++i) {
                JSONObject joData = dataJSON.getJSONObject(i);
                SchoolAdmin objectValue = (SchoolAdmin)mapper.readValue(joData.getString("data"), SchoolAdmin.class);
                objectList.add(objectValue);
            }
        }
        return objectList;
    }
}

