/*
 * Decompiled with CFR 0.152.
 */
package com.evotext.clever;

import com.evotext.clever.CleverClient;
import com.evotext.clever.model.Link;
import com.evotext.clever.model.Paging;
import com.evotext.clever.model.School;
import com.evotext.clever.model.Section;
import com.evotext.clever.model.Student;
import com.evotext.clever.model.Teacher;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class CleverSchoolsClient
extends CleverClient {
    private String m_districtOAuthToken;

    public CleverSchoolsClient(String districtOAuthToken) {
        this.m_districtOAuthToken = districtOAuthToken;
    }

    public School getSchool(String schoolId) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("schools/" + schoolId);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        JSONObject responseJSON = this.get(fullApiUrl.toString(), this.m_districtOAuthToken, parameters);
        ObjectMapper mapper = new ObjectMapper();
        School objectValue = (School)mapper.readValue(responseJSON.getString("data"), School.class);
        return objectValue;
    }

    public BigInteger countSchoolTeachers(String schoolId) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("schools/");
        fullApiUrl.append(schoolId);
        fullApiUrl.append("/teachers");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("limit", 1);
        JSONObject responseJSON = this.get(fullApiUrl.toString(), this.m_districtOAuthToken, parameters);
        ObjectMapper mapper = new ObjectMapper();
        Paging pagingValue = (Paging)mapper.readValue(responseJSON.getString("paging"), Paging.class);
        BigInteger recordCount = new BigInteger(pagingValue.getTotal());
        return recordCount;
    }

    public List<Teacher> getSchoolTeachers(String schoolId, int limit, String startingAfter, String endingBefore) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("schools/");
        fullApiUrl.append(schoolId);
        fullApiUrl.append("/teachers");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("limit", limit);
        if (StringUtils.isNotEmpty((CharSequence)startingAfter)) {
            parameters.put("starting_after", startingAfter);
        }
        if (StringUtils.isNotEmpty((CharSequence)endingBefore)) {
            parameters.put("ending_before", endingBefore);
        }
        JSONObject responseJSON = this.get(fullApiUrl.toString(), this.m_districtOAuthToken, parameters);
        JSONArray dataJSON = responseJSON.getJSONArray("data");
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<Teacher> objectList = new ArrayList<Teacher>();
        for (int i = 0; i < dataJSON.length(); ++i) {
            JSONObject joData = dataJSON.getJSONObject(i);
            Teacher objectValue = (Teacher)mapper.readValue(joData.getString("data"), Teacher.class);
            objectList.add(objectValue);
        }
        return objectList;
    }

    public List<Teacher> getAllSchoolTeachers(String schoolId) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("schools/");
        fullApiUrl.append(schoolId);
        fullApiUrl.append("/teachers");
        ArrayList<Teacher> objectList = new ArrayList<Teacher>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("limit", 100);
        String uri = fullApiUrl.toString();
        boolean keepGoing = true;
        while (keepGoing) {
            keepGoing = false;
            JSONObject responseJSON = this.get(uri, this.m_districtOAuthToken, parameters);
            ObjectMapper mapper = new ObjectMapper();
            List<Link> linkList = this.getLinkList(responseJSON);
            for (Link link : linkList) {
                if (!StringUtils.equals((CharSequence)link.getRel(), (CharSequence)"next")) continue;
                keepGoing = true;
                uri = this.getApiUrl() + link.getUri();
            }
            JSONArray dataJSON = responseJSON.getJSONArray("data");
            for (int i = 0; i < dataJSON.length(); ++i) {
                JSONObject joData = dataJSON.getJSONObject(i);
                Teacher objectValue = (Teacher)mapper.readValue(joData.getString("data"), Teacher.class);
                objectList.add(objectValue);
            }
        }
        return objectList;
    }

    public BigInteger countSchoolStudents(String schoolId) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("schools/");
        fullApiUrl.append(schoolId);
        fullApiUrl.append("/students");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("limit", 1);
        JSONObject responseJSON = this.get(fullApiUrl.toString(), this.m_districtOAuthToken, parameters);
        ObjectMapper mapper = new ObjectMapper();
        Paging pagingValue = (Paging)mapper.readValue(responseJSON.getString("paging"), Paging.class);
        BigInteger recordCount = new BigInteger(pagingValue.getTotal());
        return recordCount;
    }

    public List<Student> getSchoolStudents(String schoolId, int limit, String startingAfter, String endingBefore) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("schools/");
        fullApiUrl.append(schoolId);
        fullApiUrl.append("/students");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("limit", limit);
        if (StringUtils.isNotEmpty((CharSequence)startingAfter)) {
            parameters.put("starting_after", startingAfter);
        }
        if (StringUtils.isNotEmpty((CharSequence)endingBefore)) {
            parameters.put("ending_before", endingBefore);
        }
        JSONObject responseJSON = this.get(fullApiUrl.toString(), this.m_districtOAuthToken, parameters);
        JSONArray dataJSON = responseJSON.getJSONArray("data");
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<Student> objectList = new ArrayList<Student>();
        for (int i = 0; i < dataJSON.length(); ++i) {
            JSONObject joData = dataJSON.getJSONObject(i);
            Student objectValue = (Student)mapper.readValue(joData.getString("data"), Student.class);
            objectList.add(objectValue);
        }
        return objectList;
    }

    public List<Student> getAllSchoolStudents(String schoolId) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("schools/");
        fullApiUrl.append(schoolId);
        fullApiUrl.append("/students");
        ArrayList<Student> objectList = new ArrayList<Student>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("limit", 100);
        String uri = fullApiUrl.toString();
        boolean keepGoing = true;
        while (keepGoing) {
            keepGoing = false;
            JSONObject responseJSON = this.get(uri, this.m_districtOAuthToken, parameters);
            ObjectMapper mapper = new ObjectMapper();
            List<Link> linkList = this.getLinkList(responseJSON);
            for (Link link : linkList) {
                if (!StringUtils.equals((CharSequence)link.getRel(), (CharSequence)"next")) continue;
                keepGoing = true;
                uri = this.getApiUrl() + link.getUri();
            }
            JSONArray dataJSON = responseJSON.getJSONArray("data");
            for (int i = 0; i < dataJSON.length(); ++i) {
                JSONObject joData = dataJSON.getJSONObject(i);
                Student objectValue = (Student)mapper.readValue(joData.getString("data"), Student.class);
                objectList.add(objectValue);
            }
        }
        return objectList;
    }

    public BigInteger countSchoolSections(String schoolId) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("schools/");
        fullApiUrl.append(schoolId);
        fullApiUrl.append("/sections");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("limit", 1);
        JSONObject responseJSON = this.get(fullApiUrl.toString(), this.m_districtOAuthToken, parameters);
        ObjectMapper mapper = new ObjectMapper();
        Paging pagingValue = (Paging)mapper.readValue(responseJSON.getString("paging"), Paging.class);
        BigInteger recordCount = new BigInteger(pagingValue.getTotal());
        return recordCount;
    }

    public List<Section> getSchoolSections(String schoolId, int limit, String startingAfter, String endingBefore) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("schools/");
        fullApiUrl.append(schoolId);
        fullApiUrl.append("/sections");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("limit", limit);
        if (StringUtils.isNotEmpty((CharSequence)startingAfter)) {
            parameters.put("starting_after", startingAfter);
        }
        if (StringUtils.isNotEmpty((CharSequence)endingBefore)) {
            parameters.put("ending_before", endingBefore);
        }
        JSONObject responseJSON = this.get(fullApiUrl.toString(), this.m_districtOAuthToken, parameters);
        JSONArray dataJSON = responseJSON.getJSONArray("data");
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<Section> objectList = new ArrayList<Section>();
        for (int i = 0; i < dataJSON.length(); ++i) {
            JSONObject joData = dataJSON.getJSONObject(i);
            Section objectValue = (Section)mapper.readValue(joData.getString("data"), Section.class);
            objectList.add(objectValue);
        }
        return objectList;
    }

    public List<Section> getAllSchoolSections(String schoolId) throws Exception {
        StringBuffer fullApiUrl = new StringBuffer();
        fullApiUrl.append(this.getBaseUrl());
        fullApiUrl.append("schools/");
        fullApiUrl.append(schoolId);
        fullApiUrl.append("/sections");
        ArrayList<Section> objectList = new ArrayList<Section>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("limit", 100);
        String uri = fullApiUrl.toString();
        boolean keepGoing = true;
        while (keepGoing) {
            keepGoing = false;
            JSONObject responseJSON = this.get(uri, this.m_districtOAuthToken, parameters);
            ObjectMapper mapper = new ObjectMapper();
            List<Link> linkList = this.getLinkList(responseJSON);
            for (Link link : linkList) {
                if (!StringUtils.equals((CharSequence)link.getRel(), (CharSequence)"next")) continue;
                keepGoing = true;
                uri = this.getApiUrl() + link.getUri();
            }
            JSONArray dataJSON = responseJSON.getJSONArray("data");
            for (int i = 0; i < dataJSON.length(); ++i) {
                JSONObject joData = dataJSON.getJSONObject(i);
                Section objectValue = (Section)mapper.readValue(joData.getString("data"), Section.class);
                objectList.add(objectValue);
            }
        }
        return objectList;
    }
}

