/*
 * Decompiled with CFR 0.152.
 */
package com.evotext.clever.requests;

import com.evotext.clever.requests.CleverRequest;
import com.evotext.clever.requests.CleverRequestInterface;
import java.util.HashMap;
import java.util.Map;

public class IdListRequest
extends CleverRequest
implements CleverRequestInterface {
    private String id;
    protected int limit = 100;
    protected String startingAfter;
    protected String endingBefore;
    protected String where;
    protected boolean count = false;

    @Override
    public String getId() {
        return this.id;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getStartingAfter() {
        return this.startingAfter;
    }

    public String getEndingBefore() {
        return this.endingBefore;
    }

    public String getWhere() {
        return this.where;
    }

    public boolean isCount() {
        return this.count;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.count) {
            parameters.put("count", "true");
        }
        return parameters;
    }

    private IdListRequest(Builder builder) {
        this.id = builder.id;
        this.limit = builder.limit;
        this.startingAfter = builder.startingAfter;
        this.endingBefore = builder.endingBefore;
        this.where = builder.where;
        this.count = builder.count;
        this.parameters = builder.parameters;
        this.url = builder.url;
        this.token = builder.token;
    }

    public static class Builder {
        private String id;
        private int limit;
        private String startingAfter;
        private String endingBefore;
        private String where;
        private boolean count;
        private String url;
        private String token;
        private Map<String, Object> parameters = new HashMap<String, Object>();

        public Builder(String token, String url, String id) {
            this.id = id;
            this.url = url;
            this.token = token;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            this.parameters.put("limit", limit);
            return this;
        }

        public Builder startingAfter(String startingAfter) {
            this.startingAfter = startingAfter;
            this.parameters.put("startingAfter", startingAfter);
            return this;
        }

        public Builder endingBefore(String endingBefore) {
            this.endingBefore = endingBefore;
            this.parameters.put("endingBefore", endingBefore);
            return this;
        }

        public Builder where(String where) {
            this.where = where;
            this.parameters.put("where", where);
            return this;
        }

        public Builder count(boolean count) {
            this.count = count;
            return this;
        }

        public IdListRequest build() {
            return new IdListRequest(this);
        }
    }
}

