/*
 * Decompiled with CFR 0.152.
 */
package com.evotext.clever.requests;

import com.evotext.clever.requests.CleverRequest;
import com.evotext.clever.requests.CleverRequestInterface;
import java.util.HashMap;
import java.util.Map;

public class ListRequest
extends CleverRequest
implements CleverRequestInterface {
    protected int limit = 100;
    protected String startingAfter;
    protected String endingBefore;
    protected String where;
    protected boolean count = false;

    public int getLimit() {
        return this.limit;
    }

    public String getStartingAfter() {
        return this.startingAfter;
    }

    public String getEndingBefore() {
        return this.endingBefore;
    }

    public String getWhere() {
        return this.where;
    }

    public boolean isCount() {
        return this.count;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.count) {
            parameters.put("count", "true");
        }
        return parameters;
    }

    protected ListRequest(Builder builder) {
        this.limit = builder.limit;
        this.startingAfter = builder.startingAfter;
        this.endingBefore = builder.endingBefore;
        this.where = builder.where;
        this.count = builder.count;
        this.parameters = builder.parameters;
        this.token = builder.token;
        this.url = builder.url;
    }

    public static class Builder {
        private int limit;
        private String startingAfter;
        private String endingBefore;
        private String where;
        private boolean count;
        private Map<String, Object> parameters = new HashMap<String, Object>();
        private String token;
        private String url;

        public Builder(String token, String url) {
            this.token = token;
            this.url = url;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            this.parameters.put("limit", limit);
            return this;
        }

        public Builder startingAfter(String startingAfter) {
            this.startingAfter = startingAfter;
            this.parameters.put("startingAfter", startingAfter);
            return this;
        }

        public Builder endingBefore(String endingBefore) {
            this.endingBefore = endingBefore;
            this.parameters.put("endingBefore", endingBefore);
            return this;
        }

        public Builder where(String where) {
            this.where = where;
            this.parameters.put("where", where);
            return this;
        }

        public Builder count(boolean count) {
            this.count = count;
            return this;
        }

        public ListRequest build() {
            return new ListRequest(this);
        }
    }
}

