/*
 * Decompiled with CFR 0.152.
 */
package com.evotext.clever.util;

import com.evotext.clever.model.Teacher;
import com.evotext.clever.requests.IdListRequest;
import com.evotext.clever.requests.ListRequest;
import com.evotext.clever.util.Clever;
import com.evotext.clever.util.Connect;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Caller {
    public static List<Teacher> getTeachers(Clever clever) throws JsonParseException, JsonMappingException, IOException, JSONException {
        String url = clever.getFullUrl() + "teachers";
        ListRequest request = new ListRequest.Builder(clever.getToken(), url).build();
        JSONObject jo = Connect.get(request);
        JSONArray arrJson = jo.getJSONArray("data");
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<Teacher> list = new ArrayList<Teacher>();
        for (int i = 0; i < arrJson.length(); ++i) {
            JSONObject joData = arrJson.getJSONObject(i);
            Teacher teacher = (Teacher)mapper.readValue(joData.getString("data"), Teacher.class);
            list.add(teacher);
        }
        return list;
    }

    public static Teacher getTeacher(String id, Clever clever) throws JSONException, JsonParseException, JsonMappingException, IOException {
        String url = clever.getFullUrl() + "teachers/" + id;
        IdListRequest request = new IdListRequest.Builder(clever.getToken(), url, id).build();
        JSONObject jo = Connect.get(request);
        ObjectMapper mapper = new ObjectMapper();
        Teacher teacher = (Teacher)mapper.readValue(jo.getString("data"), Teacher.class);
        return teacher;
    }

    public static int getTeacherCount(Clever clever) throws JSONException {
        String url = clever.getFullUrl() + "teachers";
        ListRequest request = new ListRequest.Builder(clever.getToken(), url).count(true).build();
        JSONObject jo = Connect.get(request);
        int i = jo.getInt("count");
        System.out.println(jo);
        return i;
    }
}

