/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.transaction;

import com.ursful.framework.orm.support.ChangeHolder;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class TransactionManager
extends DataSourceTransactionManager {
    private static Logger logger = LoggerFactory.getLogger(TransactionManager.class);

    public TransactionManager(DataSource dataSource) {
        super(dataSource);
    }

    public TransactionManager() {
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        String key = "transaction-" + UUID.randomUUID().toString();
        logger.debug("begin...." + key);
        ChangeHolder.set(key);
        super.doBegin(transaction, definition);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        logger.debug("commit...." + ChangeHolder.get());
        super.doCommit(status);
        ChangeHolder.change();
    }

    protected void doRollback(DefaultTransactionStatus status) {
        logger.debug("rollback...." + ChangeHolder.get());
        ChangeHolder.remove();
        super.doRollback(status);
    }
}

