/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.query;

import com.ursful.framework.orm.IBaseQuery;
import com.ursful.framework.orm.annotation.RdTable;
import com.ursful.framework.orm.query.QueryImpl;
import com.ursful.framework.orm.query.QueryUtils;
import com.ursful.framework.orm.support.Column;
import com.ursful.framework.orm.support.Condition;
import com.ursful.framework.orm.support.Expression;
import com.ursful.framework.orm.support.ExpressionType;
import com.ursful.framework.orm.support.LambdaQuery;
import com.ursful.framework.orm.support.Order;
import com.ursful.framework.orm.support.QueryInfo;
import com.ursful.framework.orm.utils.ORMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;

public class BaseQueryImpl
extends QueryImpl
implements IBaseQuery {
    private Class<?> table;
    private Class<?> returnClass;
    private List<Column> returnColumns = new ArrayList<Column>();
    private List<Column> fixedReturnColumns = new ArrayList<Column>();
    private List<Column> groups = new ArrayList<Column>();
    private List<Column> groupCountsSelectColumns = new ArrayList<Column>();

    @Override
    public IBaseQuery orderDesc(String name) {
        this.orders.add(new Order(new Column(name), "DESC"));
        return this;
    }

    @Override
    public IBaseQuery whereIsNull(String name) {
        this.addCondition(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_NULL)));
        return this;
    }

    @Override
    public IBaseQuery whereIsNotNull(String name) {
        this.addCondition(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_NOT_NULL)));
        return this;
    }

    @Override
    public IBaseQuery whereIsEmpty(String name) {
        this.addCondition(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_EMPTY)));
        return this;
    }

    @Override
    public IBaseQuery whereIsNotEmpty(String name) {
        this.addCondition(new Condition().and(new Expression(new Column(name), ExpressionType.CDT_IS_NOT_EMPTY)));
        return this;
    }

    @Override
    public <T, R> IBaseQuery where(LambdaQuery<T, R> fieldFunction, ExpressionType type) {
        return this.where(fieldFunction.getColumnName(), type);
    }

    @Override
    public IBaseQuery where(String name, ExpressionType type) {
        if (ExpressionType.CDT_IS_NULL == type || ExpressionType.CDT_IS_NOT_NULL == type || ExpressionType.CDT_IS_EMPTY == type || ExpressionType.CDT_IS_NOT_EMPTY == type) {
            this.addCondition(new Condition().and(new Expression(new Column(name), type)));
        }
        return this;
    }

    @Override
    public <T, R> IBaseQuery whereEqual(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereEqual(fieldFunction.getColumnName(), value);
    }

    @Override
    public IBaseQuery whereEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_EQUAL);
    }

    @Override
    public <T, R> IBaseQuery whereNotEqual(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereNotEqual(fieldFunction.getColumnName(), value);
    }

    @Override
    public IBaseQuery whereNotEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_NOT_EQUAL);
    }

    @Override
    public IBaseQuery whereLike(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_LIKE);
    }

    @Override
    public IBaseQuery whereNotLike(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_NOT_LIKE);
    }

    @Override
    public IBaseQuery whereStartWith(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_START_WITH);
    }

    @Override
    public IBaseQuery whereEndWith(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_END_WITH);
    }

    @Override
    public IBaseQuery whereNotStartWith(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_NOT_START_WITH);
    }

    @Override
    public IBaseQuery whereNotEndWith(String name, String value) {
        return this.where(name, (Object)value, ExpressionType.CDT_NOT_END_WITH);
    }

    @Override
    public <T, R> IBaseQuery whereLike(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereLike(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> IBaseQuery whereNotLike(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereNotLike(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> IBaseQuery whereStartWith(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereStartWith(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> IBaseQuery whereEndWith(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereEndWith(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> IBaseQuery whereNotStartWith(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereNotStartWith(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> IBaseQuery whereNotEndWith(LambdaQuery<T, R> fieldFunction, String value) {
        return this.whereNotEndWith(fieldFunction.getColumnName(), value);
    }

    @Override
    public IBaseQuery whereLess(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_LESS);
    }

    @Override
    public IBaseQuery whereLessEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_LESS_EQUAL);
    }

    @Override
    public IBaseQuery whereMore(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_MORE);
    }

    @Override
    public IBaseQuery whereMoreEqual(String name, Object value) {
        return this.where(name, value, ExpressionType.CDT_MORE_EQUAL);
    }

    @Override
    public <T, R> IBaseQuery whereLess(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereLess(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> IBaseQuery whereLessEqual(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereLessEqual(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> IBaseQuery whereMore(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereMore(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> IBaseQuery whereMoreEqual(LambdaQuery<T, R> fieldFunction, Object value) {
        return this.whereMoreEqual(fieldFunction.getColumnName(), value);
    }

    @Override
    public IBaseQuery whereIn(String name, Collection value) {
        return this.where(name, (Object)value, ExpressionType.CDT_IN);
    }

    @Override
    public IBaseQuery whereNotIn(String name, Collection value) {
        return this.where(name, (Object)value, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public IBaseQuery whereInValues(String name, Object ... values) {
        List<Object> temp = null;
        temp = values != null ? Arrays.asList(values) : new ArrayList<Object>();
        return this.where(name, temp, ExpressionType.CDT_IN);
    }

    @Override
    public IBaseQuery whereNotInValues(String name, Object ... values) {
        List<Object> temp = null;
        temp = values != null ? Arrays.asList(values) : new ArrayList<Object>();
        return this.where(name, temp, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public <T, R> IBaseQuery whereIn(LambdaQuery<T, R> fieldFunction, Collection value) {
        return this.whereIn(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> IBaseQuery whereNotIn(LambdaQuery<T, R> fieldFunction, Collection value) {
        return this.whereNotIn(fieldFunction.getColumnName(), value);
    }

    @Override
    public <T, R> IBaseQuery whereInValues(LambdaQuery<T, R> fieldFunction, Object ... values) {
        return this.whereInValues(fieldFunction.getColumnName(), values);
    }

    @Override
    public <T, R> IBaseQuery whereNotInValues(LambdaQuery<T, R> fieldFunction, Object ... values) {
        return this.whereNotInValues(fieldFunction.getColumnName(), values);
    }

    @Override
    public IBaseQuery where(String name, Object value, ExpressionType type) {
        this.addCondition(new Condition().and(new Expression(new Column(name), value, type)));
        return this;
    }

    @Override
    public <T, R> IBaseQuery whereIsNull(LambdaQuery<T, R> fieldFunction) {
        return this.whereIsNull(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> IBaseQuery whereIsNotNull(LambdaQuery<T, R> fieldFunction) {
        return this.whereIsNotNull(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> IBaseQuery whereIsEmpty(LambdaQuery<T, R> fieldFunction) {
        return this.whereIsEmpty(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> IBaseQuery whereIsNotEmpty(LambdaQuery<T, R> fieldFunction) {
        return this.whereIsNotEmpty(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> IBaseQuery where(LambdaQuery<T, R> fieldFunction, Object value, ExpressionType type) {
        return this.where(fieldFunction.getColumnName(), value, type);
    }

    @Override
    public IBaseQuery where(Condition condition) {
        if (condition != null) {
            this.addCondition(condition);
        }
        return this;
    }

    @Override
    public IBaseQuery whereBetween(String name, Object value, Object andValue) {
        if (!ORMUtils.isEmpty(value) && !ORMUtils.isEmpty(andValue)) {
            Expression expression = new Expression(new Column(name), value, ExpressionType.CDT_BETWEEN);
            expression.setAndValue(andValue);
            this.addCondition(new Condition().and(expression));
        }
        return this;
    }

    @Override
    public <T, R> IBaseQuery whereBetween(LambdaQuery<T, R> fieldFunction, Object value, Object andValue) {
        return this.whereBetween(fieldFunction.getColumnName(), value, andValue);
    }

    @Override
    public IBaseQuery where(Expression ... expressions) {
        this.addCondition(new Condition().and(expressions));
        return this;
    }

    @Override
    public IBaseQuery group(String name) {
        this.groups.add(new Column(name));
        return this;
    }

    @Override
    public List<Column> getGroupCountSelectColumns() {
        return this.groupCountsSelectColumns;
    }

    @Override
    public IBaseQuery groupCountSelectColumn(String name) {
        this.groupCountsSelectColumns.add(new Column(name));
        return this;
    }

    @Override
    public IBaseQuery having(String name, Object value, ExpressionType type) {
        if (value == null) {
            return this;
        }
        if ("".equals(value)) {
            return this;
        }
        this.addHaving(new Condition().or(new Expression(new Column(name), value, type)));
        return this;
    }

    @Override
    public <T, R> IBaseQuery group(LambdaQuery<T, R> fieldFunction) {
        return this.group(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> IBaseQuery groupCountSelectColumn(LambdaQuery<T, R> fieldFunction) {
        return this.groupCountSelectColumn(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> IBaseQuery having(LambdaQuery<T, R> fieldFunction, Object value, ExpressionType type) {
        return this.having(fieldFunction.getColumnName(), value, type);
    }

    @Override
    public IBaseQuery having(Condition condition) {
        this.addCondition(condition);
        return this;
    }

    @Override
    public IBaseQuery orderAsc(String name) {
        this.orders.add(new Order(new Column(name), "ASC"));
        return this;
    }

    @Override
    public <T, R> IBaseQuery orderDesc(LambdaQuery<T, R> fieldFunction) {
        return this.orderDesc(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> IBaseQuery orderAsc(LambdaQuery<T, R> fieldFunction) {
        return this.orderAsc(fieldFunction.getColumnName());
    }

    @Override
    public IBaseQuery order(Order order) {
        if (order != null) {
            this.orders.add(order);
        }
        return this;
    }

    @Override
    public IBaseQuery orders(List<Order> os) {
        if (os != null) {
            for (Order order : os) {
                this.orders.add(order);
            }
        }
        return this;
    }

    @Override
    public <T, R> IBaseQuery createQuery(LambdaQuery<T, R> ... lambdaQueries) {
        return this.createQuery(QueryUtils.getColumns(lambdaQueries));
    }

    @Override
    public <T, R> IBaseQuery createQuery(Class<?> clazz, LambdaQuery<T, R> ... names) {
        return this.createQuery(clazz, QueryUtils.getColumns(names));
    }

    @Override
    public IBaseQuery createQuery(Class<?> clazz, String ... names) {
        this.returnClass = clazz;
        this.returnColumns.clear();
        this.fixedReturnColumns.clear();
        if (names != null) {
            for (String name : names) {
                this.returnColumns.add(new Column(name));
            }
        }
        return this;
    }

    @Override
    public IBaseQuery createQuery(Class<?> clazz, Column ... columns) {
        this.returnClass = clazz;
        this.returnColumns.clear();
        this.fixedReturnColumns.clear();
        if (columns != null) {
            for (Column column : columns) {
                this.returnColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public IBaseQuery addReturnColumn(Column column) {
        if (column != null) {
            this.returnColumns.add(column);
        }
        return this;
    }

    @Override
    public IBaseQuery addReturnColumn(String column) {
        if (ORMUtils.isEmpty(column)) {
            this.returnColumns.add(new Column(column));
        }
        return this;
    }

    @Override
    public IBaseQuery clearReturnColumns() {
        this.returnColumns.clear();
        return this;
    }

    @Override
    public IBaseQuery addFixedReturnColumn(Column column) {
        if (column != null) {
            this.fixedReturnColumns.add(column);
        }
        return this;
    }

    @Override
    public <T, R> IBaseQuery addReturnColumn(LambdaQuery<T, R> fieldFunction) {
        return this.addReturnColumn(fieldFunction.getColumnName());
    }

    @Override
    public <T, R> IBaseQuery addFixedReturnColumn(LambdaQuery<T, R> fieldFunction) {
        return this.addFixedReturnColumn(fieldFunction.getColumnName());
    }

    @Override
    public IBaseQuery addFixedReturnColumn(String column) {
        if (ORMUtils.isEmpty(column)) {
            this.fixedReturnColumns.add(new Column(column));
        }
        return this;
    }

    @Override
    public IBaseQuery clearFixedReturnColumns() {
        this.returnColumns.clear();
        return this;
    }

    @Override
    public IBaseQuery createQuery(String ... names) {
        this.returnClass = this.table;
        this.returnColumns.clear();
        this.fixedReturnColumns.clear();
        if (names != null) {
            for (String name : names) {
                this.returnColumns.add(new Column(name));
            }
        }
        return this;
    }

    public IBaseQuery createQuery(Column ... columns) {
        this.returnClass = this.table;
        this.returnColumns.clear();
        this.fixedReturnColumns.clear();
        if (columns != null) {
            for (Column column : columns) {
                this.returnColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public IBaseQuery distinct() {
        this.distinct = true;
        return this;
    }

    @Override
    public IBaseQuery table(Class<?> clazz) {
        RdTable rdTable;
        if (clazz != null && (rdTable = (RdTable)AnnotationUtils.findAnnotation(clazz, RdTable.class)) != null) {
            this.table = clazz;
            this.returnClass = clazz;
        }
        return this;
    }

    @Override
    public Class<?> getTable() {
        return this.table;
    }

    @Override
    public List<Column> getGroups() {
        return this.groups;
    }

    @Override
    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    @Override
    public List<Column> getReturnColumns() {
        ArrayList<Column> columnList = new ArrayList<Column>();
        if (this.returnColumns.isEmpty()) {
            columnList.add(new Column("*"));
        } else {
            columnList.addAll(this.returnColumns);
        }
        return columnList;
    }

    @Override
    public List<Column> getFinalReturnColumns() {
        ArrayList<Column> columnList = new ArrayList<Column>();
        columnList.addAll(this.getReturnColumns());
        columnList.addAll(this.fixedReturnColumns);
        return columnList;
    }

    @Override
    public List<Column> getFixedReturnColumns() {
        return this.fixedReturnColumns;
    }

    @Override
    public QueryInfo doQuery() {
        return this.options.doQuery(this, this.getPageable());
    }

    @Override
    public QueryInfo doQueryCount() {
        return this.options.doQueryCount(this);
    }
}

