/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.spring;

import com.objectsql.ObjectSQLManager;
import com.objectsql.support.CommitHandler;
import com.objectsql.support.ExecuteHandler;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TxCommit {
    private PlatformTransactionManager transactionManager;
    private TransactionStatus status;
    private boolean executeSuccess = false;
    private CommitHandler commitHandler;
    private int propagation;
    private int isolationLevel;

    public TxCommit(PlatformTransactionManager manager) {
        this(manager, 0, -1);
    }

    public TxCommit(PlatformTransactionManager manager, int propagation) {
        this(manager, propagation, -1);
    }

    public TxCommit(PlatformTransactionManager manager, int propagation, int isolationLevel) {
        this.transactionManager = manager;
        this.propagation = propagation;
        this.isolationLevel = isolationLevel;
    }

    public TxCommit(ObjectSQLManager sqlManager) {
        this(sqlManager.getDataSource(), 0, -1);
    }

    public TxCommit(ObjectSQLManager sqlManager, int propagation) {
        this(sqlManager.getDataSource(), propagation, -1);
    }

    public TxCommit(ObjectSQLManager sqlManager, int propagation, int isolationLevel) {
        this((PlatformTransactionManager)new DataSourceTransactionManager(sqlManager.getDataSource()), propagation, isolationLevel);
    }

    public TxCommit(DataSource dataSource) {
        this(dataSource, 0, -1);
    }

    public TxCommit(DataSource dataSource, int propagation) {
        this(dataSource, propagation, -1);
    }

    public TxCommit(DataSource dataSource, int propagation, int isolationLevel) {
        this((PlatformTransactionManager)new DataSourceTransactionManager(dataSource), propagation, isolationLevel);
    }

    public <T> T execute(ExecuteHandler<T> handler) {
        return this.execute(handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(ExecuteHandler<T> handler, CommitHandler<T> commitHandler) {
        T result = null;
        if (handler == null) {
            return result;
        }
        try {
            this.manual();
            result = handler.execute();
            if (handler.shouldRollback(result)) {
                this.rollback();
            } else {
                this.commit();
            }
        }
        catch (Exception e) {
            if (commitHandler != null) {
                commitHandler.handle(result, e);
            }
        }
        finally {
            if (!this.executeSuccess) {
                this.rollback();
            }
        }
        return result;
    }

    public boolean isExecuteSuccess() {
        return this.executeSuccess;
    }

    private void manual() {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(this.propagation);
        definition.setIsolationLevel(this.isolationLevel);
        this.status = this.transactionManager.getTransaction((TransactionDefinition)definition);
        this.executeSuccess = false;
    }

    private void commit() {
        if (this.transactionManager != null && this.status != null) {
            this.transactionManager.commit(this.status);
            this.executeSuccess = true;
        }
    }

    private void rollback() {
        if (!this.executeSuccess && this.transactionManager != null && this.status != null) {
            this.transactionManager.rollback(this.status);
        }
    }

    public static <T> T tx(DataSource dataSource, ExecuteHandler<T> handler) {
        return new TxCommit(dataSource).execute(handler);
    }

    public static <T> T tx(DataSource dataSource, int propagation, ExecuteHandler<T> handler) {
        return new TxCommit(dataSource, propagation).execute(handler);
    }

    public static <T> T tx(DataSource dataSource, int propagation, int isolationLevel, ExecuteHandler<T> handler) {
        return new TxCommit(dataSource, propagation, isolationLevel).execute(handler);
    }

    public static <T> T tx(DataSource dataSource, ExecuteHandler<T> handler, CommitHandler<T> commitHandler) {
        return new TxCommit(dataSource).execute(handler, commitHandler);
    }

    public static <T> T tx(DataSource dataSource, int propagation, ExecuteHandler<T> handler, CommitHandler<T> commitHandler) {
        return new TxCommit(dataSource, propagation).execute(handler, commitHandler);
    }

    public static <T> T tx(DataSource dataSource, int propagation, int isolationLevel, ExecuteHandler<T> handler, CommitHandler<T> commitHandler) {
        return new TxCommit(dataSource, propagation, isolationLevel).execute(handler, commitHandler);
    }

    public static <T> T tx(ObjectSQLManager objectSQLManager, ExecuteHandler<T> handler) {
        return new TxCommit(objectSQLManager).execute(handler);
    }

    public static <T> T tx(ObjectSQLManager objectSQLManager, int propagation, ExecuteHandler<T> handler) {
        return new TxCommit(objectSQLManager, propagation).execute(handler);
    }

    public static <T> T tx(ObjectSQLManager objectSQLManager, int propagation, int isolationLevel, ExecuteHandler<T> handler) {
        return new TxCommit(objectSQLManager, propagation, isolationLevel).execute(handler);
    }

    public static <T> T tx(ObjectSQLManager objectSQLManager, ExecuteHandler<T> handler, CommitHandler<T> commitHandler) {
        return new TxCommit(objectSQLManager).execute(handler, commitHandler);
    }

    public static <T> T tx(ObjectSQLManager objectSQLManager, int propagation, ExecuteHandler<T> handler, CommitHandler<T> commitHandler) {
        return new TxCommit(objectSQLManager, propagation).execute(handler, commitHandler);
    }

    public static <T> T tx(ObjectSQLManager objectSQLManager, int propagation, int isolationLevel, ExecuteHandler<T> handler, CommitHandler<T> commitHandler) {
        return new TxCommit(objectSQLManager, propagation, isolationLevel).execute(handler, commitHandler);
    }

    public static <T> T tx(DataSourceTransactionManager dataSourceTransactionManager, ExecuteHandler<T> handler) {
        return new TxCommit((PlatformTransactionManager)dataSourceTransactionManager).execute(handler);
    }

    public static <T> T tx(DataSourceTransactionManager dataSourceTransactionManager, int propagation, ExecuteHandler<T> handler) {
        return new TxCommit((PlatformTransactionManager)dataSourceTransactionManager, propagation).execute(handler);
    }

    public static <T> T tx(DataSourceTransactionManager dataSourceTransactionManager, int propagation, int isolationLevel, ExecuteHandler<T> handler) {
        return new TxCommit((PlatformTransactionManager)dataSourceTransactionManager, propagation, isolationLevel).execute(handler);
    }

    public static <T> T tx(DataSourceTransactionManager dataSourceTransactionManager, ExecuteHandler<T> handler, CommitHandler<T> commitHandler) {
        return new TxCommit((PlatformTransactionManager)dataSourceTransactionManager).execute(handler, commitHandler);
    }

    public static <T> T tx(DataSourceTransactionManager dataSourceTransactionManager, int propagation, ExecuteHandler<T> handler, CommitHandler<T> commitHandler) {
        return new TxCommit((PlatformTransactionManager)dataSourceTransactionManager, propagation).execute(handler, commitHandler);
    }

    public static <T> T tx(DataSourceTransactionManager dataSourceTransactionManager, int propagation, int isolationLevel, ExecuteHandler<T> handler, CommitHandler<T> commitHandler) {
        return new TxCommit((PlatformTransactionManager)dataSourceTransactionManager, propagation, isolationLevel).execute(handler, commitHandler);
    }
}

