/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.support;

import com.objectsql.support.AliasTable;
import com.objectsql.support.Column;
import com.objectsql.support.Condition;
import com.objectsql.support.Expression;
import com.objectsql.support.ExpressionType;
import com.objectsql.support.JoinType;
import com.objectsql.support.LambdaQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Join
implements Serializable {
    private static final long serialVersionUID = 1L;
    private JoinType type;
    private List<Condition> conditions;
    private AliasTable table;

    public Object getTable() {
        return this.table.getTable();
    }

    public Join(AliasTable table) {
        this(table, JoinType.LEFT_JOIN);
    }

    public Join(AliasTable table, JoinType type) {
        this.table = table;
        this.type = type;
        this.conditions = new ArrayList<Condition>();
    }

    public static Join create(AliasTable table) {
        return new Join(table);
    }

    public static Join create(AliasTable table, JoinType type) {
        return new Join(table, type);
    }

    public Join on(Column column, Object value, ExpressionType expressionType) {
        this.conditions.add(new Condition().and(new Expression(column, value, expressionType)));
        return this;
    }

    public Join on(String columnName, Object value, ExpressionType expressionType) {
        this.conditions.add(new Condition().and(new Expression(new Column(this.table.getAlias(), columnName), value, expressionType)));
        return this;
    }

    public <T, R> Join on(LambdaQuery<T, R> lambdaQuery, Object value, ExpressionType expressionType) {
        this.conditions.add(new Condition().and(new Expression(new Column(this.table.getAlias(), lambdaQuery.getColumnName()), value, expressionType)));
        return this;
    }

    public Join on(String columnName, Column column) {
        this.conditions.add(new Condition().and(new Expression(new Column(this.table.getAlias(), columnName), (Object)column, ExpressionType.CDT_EQUAL)));
        return this;
    }

    public <T, R> Join on(LambdaQuery<T, R> lambdaQuery, Column column) {
        this.conditions.add(new Condition().and(new Expression(new Column(this.table.getAlias(), lambdaQuery.getColumnName()), (Object)column, ExpressionType.CDT_EQUAL)));
        return this;
    }

    public Join on(Column thisColumn, Column column) {
        this.conditions.add(new Condition().and(new Expression(thisColumn, (Object)column, ExpressionType.CDT_EQUAL)));
        return this;
    }

    public Join on(Condition condition) {
        if (condition != null) {
            this.conditions.add(condition);
        }
        return this;
    }

    public JoinType getType() {
        return this.type;
    }

    public void setType(JoinType type) {
        this.type = type;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public String getAlias() {
        return this.table.getAlias();
    }
}

