/*
 * Decompiled with CFR 0.152.
 */
package com.opencastsoftware.pgtap;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.platform.commons.util.ExceptionUtils;
import org.tap4j.consumer.TapConsumer;
import org.tap4j.consumer.TapConsumerFactory;
import org.tap4j.model.Comment;
import org.tap4j.model.Directive;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.PostgreSQLContainer;

public abstract class PgTapTest {
    private final PostgreSQLContainer<?> database;
    private final Path pgTapTestPath;
    private final Path pgTapTmpPath;

    private String createPsqlCommand(Path sqlFile) {
        return String.join((CharSequence)" ", List.of("psql", "--quiet", "--tuples-only", "--no-align", "--set=ON_ERROR_ROLLBACK=1", "--set=ON_ERROR_STOP=true", "--pset=pager=off", "--username=test", "--dbname=test", "-c", "'CREATE EXTENSION IF NOT EXISTS pgtap;'", "-f", this.pgTapTmpPath.resolve(sqlFile).toString()));
    }

    public PgTapTest(PostgreSQLContainer<?> database, Path pgTapTestPath, Path pgTapTmpPath) {
        this.database = database;
        this.pgTapTestPath = pgTapTestPath;
        this.pgTapTmpPath = pgTapTmpPath;
    }

    private boolean isSqlFile(Path file, BasicFileAttributes attrs) {
        return attrs.isRegularFile() && file.getFileName().toString().endsWith(".sql");
    }

    private Stream<Path> findPgTapTests() throws IOException {
        return Files.find(this.pgTapTestPath, Integer.MAX_VALUE, this::isSqlFile, new FileVisitOption[0]);
    }

    private DynamicTest createDynamicTest(Path sqlFile, TestResult testResult) {
        DirectiveValues directiveValue;
        Directive directive = testResult.getDirective();
        if (directive != null && ((directiveValue = directive.getDirectiveValue()).equals((Object)DirectiveValues.SKIP) || directiveValue.equals((Object)DirectiveValues.TODO))) {
            String directiveReason = directive.getReason() != null ? " - " + directive.getReason() : "";
            String testName = testResult.getTestNumber() + directiveReason;
            return DynamicTest.dynamicTest((String)testName, (URI)sqlFile.toUri(), () -> Assumptions.abort((String)testResult.getDirective().getReason()));
        }
        String description = testResult.getDescription() != null ? " " + testResult.getDescription() : "";
        String testName = testResult.getTestNumber() + description;
        return DynamicTest.dynamicTest((String)testName, (URI)sqlFile.toUri(), () -> {
            if (testResult.getStatus().equals((Object)StatusValues.NOT_OK)) {
                String commentText = testResult.getComments().stream().map(Comment::getText).collect(Collectors.joining(System.lineSeparator(), System.lineSeparator(), ""));
                String failureDescription = commentText.isBlank() ? testResult.getDescription() : commentText;
                Assertions.fail((String)failureDescription);
            }
        });
    }

    @TestFactory
    Stream<DynamicNode> pgTapTests() throws IOException {
        TapConsumer consumer = TapConsumerFactory.makeTap13Consumer();
        return this.findPgTapTests().flatMap(sqlFile -> {
            try {
                Path relativeSqlFile = this.pgTapTestPath.relativize((Path)sqlFile);
                String psqlCommand = this.createPsqlCommand(relativeSqlFile);
                Container.ExecResult execResult = this.database.execInContainer(new String[]{"sh", "-c", psqlCommand});
                String tapString = execResult.getStdout();
                String errString = execResult.getStderr();
                if (!tapString.isBlank()) {
                    System.out.println(tapString);
                }
                if (!errString.isBlank()) {
                    System.err.println(errString);
                }
                if (execResult.getExitCode() != 0) {
                    return Stream.of(DynamicTest.dynamicTest((String)relativeSqlFile.toString(), (URI)sqlFile.toUri(), () -> Assertions.fail((String)(relativeSqlFile + " failed with exit code " + execResult.getExitCode()))));
                }
                TestSet tapOutput = consumer.load(tapString);
                Stream<DynamicTest> tapTests = tapOutput.getTestResults().stream().map(result -> this.createDynamicTest((Path)sqlFile, (TestResult)result));
                DynamicContainer tapTestFile = DynamicContainer.dynamicContainer((String)relativeSqlFile.toString(), (URI)sqlFile.toUri(), tapTests);
                return Stream.of(tapTestFile);
            }
            catch (IOException | InterruptedException e) {
                throw ExceptionUtils.throwAsUncheckedException((Throwable)e);
            }
        });
    }
}

