/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.Endpoint;
import java.util.concurrent.TimeUnit;

public abstract class ConnectionHealthCheckStrategy {
    public static final ConnectionHealthCheckStrategy ALWAYS_CHECK = new ConnectionHealthCheckStrategy(){

        public String toString() {
            return "ALWAYS";
        }

        @Override
        public boolean isExtensiveCheckRequired(Endpoint endpoint, long idleTime, TimeUnit idleTimeUnit) {
            return true;
        }
    };
    public static final ConnectionHealthCheckStrategy DEFAULT = ConnectionHealthCheckStrategy.ifIdleMoreThan(10L, TimeUnit.SECONDS);

    public abstract boolean isExtensiveCheckRequired(Endpoint var1, long var2, TimeUnit var4);

    public static ConnectionHealthCheckStrategy ifIdleMoreThan(final long duration, final TimeUnit timeUnit) {
        return new ConnectionHealthCheckStrategy(){

            public String toString() {
                return String.format("IfIdleFor(%d %s)", new Object[]{duration, timeUnit});
            }

            @Override
            public boolean isExtensiveCheckRequired(Endpoint endpoint, long idleTime, TimeUnit idleTimeUnit) {
                return idleTimeUnit.toNanos(idleTime) >= timeUnit.toNanos(duration);
            }
        };
    }
}

