/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.utils.IOUtils;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import okio.Buffer;
import okio.ForwardingTimeout;
import okio.Source;
import okio.Timeout;

abstract class FixedLengthSource
implements Source {
    private static final int DEFAULT_DISCARD_TIMEOUT_MILLIS = 300;
    private long bytesRemaining;
    private boolean closed;
    private final Source source;
    private final ForwardingTimeout timeout;
    private final int discardTimeoutMillis;

    protected FixedLengthSource(Source source, long contentLength, long discardTimeout, TimeUnit timeUnit) {
        this.source = source;
        this.timeout = new ForwardingTimeout(source.timeout());
        this.bytesRemaining = contentLength;
        this.discardTimeoutMillis = (int)timeUnit.toMillis(discardTimeout);
    }

    protected FixedLengthSource(Source source, long contentLength) {
        this(source, contentLength, 300L, TimeUnit.MILLISECONDS);
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public long read(Buffer sink, long byteCount) throws IOException {
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.bytesRemaining == 0L) {
            return -1L;
        }
        long read = this.source.read(sink, Math.min(this.bytesRemaining, byteCount));
        if (read == -1L) {
            this.scrap(false);
            throw new ProtocolException("unexpected end of stream");
        }
        this.bytesRemaining -= read;
        if (this.bytesRemaining == 0L) {
            this.scrap(true);
        }
        return read;
    }

    public synchronized void close() throws IOException {
        if (!this.closed && this.bytesRemaining != 0L) {
            if (this.discardTimeoutMillis != 0 && !IOUtils.skipAll((Source)this, (int)this.discardTimeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS)) {
                this.scrap(false);
            } else {
                IOUtils.skipAll((Source)this);
                this.scrap(true);
            }
            this.closed = true;
        }
    }

    public long bytesRemaining() {
        return this.bytesRemaining;
    }

    protected abstract void exhausted(boolean var1);

    private void scrap(boolean reuseSource) {
        Timeout oldDelegate = this.timeout.delegate();
        this.timeout.setDelegate(Timeout.NONE);
        oldDelegate.clearDeadline();
        oldDelegate.clearTimeout();
        this.exhausted(reuseSource);
    }
}

