/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.Request;
import com.pcloud.networking.client.Response;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;

public class MultiResponse
implements Closeable {
    private final List<Response> responses;

    MultiResponse(List<Response> responses) {
        this.responses = Collections.unmodifiableList(responses);
    }

    public Request request(int index) {
        return this.responses.get(index).request();
    }

    public Response response(int key) {
        return this.responses.get(key);
    }

    public List<Response> responses() {
        return this.responses;
    }

    @Override
    public void close() {
        for (Response r : this.responses) {
            IOUtils.closeQuietly((Closeable)r);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiResponse response = (MultiResponse)o;
        return this.responses.equals(response.responses);
    }

    public int hashCode() {
        return this.responses.hashCode();
    }

    public String toString() {
        return this.responses.toString();
    }
}

