/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.ApiChannel;
import com.pcloud.networking.client.Connection;
import com.pcloud.networking.client.ConnectionProvider;
import com.pcloud.networking.client.Endpoint;
import com.pcloud.networking.protocol.BytesReader;
import com.pcloud.networking.protocol.BytesWriter;
import com.pcloud.networking.protocol.DataSource;
import com.pcloud.networking.protocol.ForwardingProtocolRequestWriter;
import com.pcloud.networking.protocol.ForwardingProtocolResponseReader;
import com.pcloud.networking.protocol.ProtocolRequestWriter;
import com.pcloud.networking.protocol.ProtocolResponseReader;
import com.pcloud.networking.protocol.TypeToken;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import okio.BufferedSink;

class RealApiChannel
implements ApiChannel {
    private final ConnectionProvider connectionProvider;
    private Connection connection;
    private final CountingProtocolRequestWriter writer;
    private final CountingProtocolResponseReader reader;
    private final Endpoint endpoint;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    RealApiChannel(ConnectionProvider connectionProvider, Endpoint endpoint) throws IOException {
        this.connectionProvider = connectionProvider;
        this.connection = connectionProvider.obtainConnection(endpoint);
        this.endpoint = this.connection.endpoint();
        this.writer = new CountingProtocolRequestWriter((ProtocolRequestWriter)new BytesWriter(this.connection.sink()), this);
        this.reader = new CountingProtocolResponseReader((ProtocolResponseReader)new BytesReader(this.connection.source()), this);
    }

    @Override
    public Endpoint endpoint() {
        return this.endpoint;
    }

    @Override
    public ProtocolResponseReader reader() {
        return this.reader;
    }

    @Override
    public ProtocolRequestWriter writer() {
        return this.writer;
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public boolean isIdle() {
        long completedResponses;
        long sentRequests = this.writer.getCompletedRequests();
        return sentRequests == (completedResponses = this.reader.getCompletedResponses()) && this.writer.getCompletedRequests() == sentRequests && this.reader.getStartedResponses() == completedResponses;
    }

    @Override
    public void close(boolean attemptConnectionReuse) {
        if (this.closed.compareAndSet(false, true)) {
            if (attemptConnectionReuse && this.isIdle()) {
                this.connectionProvider.recycleConnection(this.connection);
            } else {
                IOUtils.closeQuietly((Closeable)this.connection);
            }
            this.connection = null;
        }
    }

    private void checkNotClosed() throws ClosedChannelException {
        if (this.closed.get()) {
            throw new ClosedChannelException();
        }
    }

    private static class CountingProtocolRequestWriter
    extends ForwardingProtocolRequestWriter {
        private final RealApiChannel apiChannel;
        private final AtomicLong startedRequests = new AtomicLong(0L);
        private final AtomicLong completedRequests = new AtomicLong(0L);

        CountingProtocolRequestWriter(ProtocolRequestWriter delegate, RealApiChannel apiChannel) {
            super(delegate);
            this.apiChannel = apiChannel;
        }

        public ProtocolRequestWriter beginRequest() throws IOException {
            this.apiChannel.checkNotClosed();
            this.startRequest();
            this.apiChannel.checkNotClosed();
            super.beginRequest();
            return this;
        }

        public ProtocolRequestWriter writeData(DataSource source) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeData(source);
            return this;
        }

        public ProtocolRequestWriter writeMethodName(String name) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeMethodName(name);
            return this;
        }

        public ProtocolRequestWriter writeName(String name) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeName(name);
            return this;
        }

        public ProtocolRequestWriter writeValue(Object value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public ProtocolRequestWriter writeValue(String value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public ProtocolRequestWriter writeValue(double value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public ProtocolRequestWriter writeValue(float value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public ProtocolRequestWriter writeValue(long value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public ProtocolRequestWriter writeValue(boolean value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public void close() {
            this.apiChannel.close();
        }

        public ProtocolRequestWriter endRequest() throws IOException {
            this.apiChannel.checkNotClosed();
            this.completeRequest();
            this.apiChannel.checkNotClosed();
            super.endRequest();
            return this;
        }

        public long getStartedRequests() {
            return this.startedRequests.get();
        }

        public long getCompletedRequests() {
            return this.completedRequests.get();
        }

        private void startRequest() {
            this.startedRequests.incrementAndGet();
        }

        private void completeRequest() {
            this.completedRequests.incrementAndGet();
        }
    }

    private static class CountingProtocolResponseReader
    extends ForwardingProtocolResponseReader {
        private final RealApiChannel apiChannel;
        private final AtomicLong startedResponses;
        private final AtomicLong completedResponses;

        CountingProtocolResponseReader(ProtocolResponseReader delegate, RealApiChannel apiChannel) {
            this(delegate, apiChannel, 0L, 0L);
        }

        private CountingProtocolResponseReader(ProtocolResponseReader delegate, RealApiChannel apiChannel, long startedResponses, long completedResponses) {
            super(delegate);
            this.apiChannel = apiChannel;
            this.startedResponses = new AtomicLong(startedResponses);
            this.completedResponses = new AtomicLong(completedResponses);
        }

        public long beginResponse() throws IOException {
            this.apiChannel.checkNotClosed();
            this.startResponse();
            this.apiChannel.checkNotClosed();
            return super.beginResponse();
        }

        public boolean endResponse() throws IOException {
            this.apiChannel.checkNotClosed();
            boolean hasData = super.endResponse();
            if (!hasData) {
                this.completeResponse();
            }
            return hasData;
        }

        public void readData(BufferedSink sink) throws IOException {
            this.apiChannel.checkNotClosed();
            super.readData(sink);
            this.completeResponse();
        }

        public void readData(OutputStream outputStream) throws IOException {
            this.apiChannel.checkNotClosed();
            super.readData(outputStream);
            this.completeResponse();
        }

        public TypeToken peek() throws IOException {
            this.apiChannel.checkNotClosed();
            return super.peek();
        }

        public void beginObject() throws IOException {
            this.apiChannel.checkNotClosed();
            super.beginObject();
        }

        public void beginArray() throws IOException {
            this.apiChannel.checkNotClosed();
            super.beginArray();
        }

        public void endArray() throws IOException {
            this.apiChannel.checkNotClosed();
            super.endArray();
        }

        public void endObject() throws IOException {
            this.apiChannel.checkNotClosed();
            super.endObject();
        }

        public boolean readBoolean() throws IOException {
            this.apiChannel.checkNotClosed();
            return super.readBoolean();
        }

        public String readString() throws IOException {
            this.apiChannel.checkNotClosed();
            return super.readString();
        }

        public long readNumber() throws IOException {
            this.apiChannel.checkNotClosed();
            return super.readNumber();
        }

        public void close() {
            this.apiChannel.close();
        }

        public boolean hasNext() throws IOException {
            this.apiChannel.checkNotClosed();
            return super.hasNext();
        }

        public void skipValue() throws IOException {
            this.apiChannel.checkNotClosed();
            super.skipValue();
        }

        public ProtocolResponseReader newPeekingReader() {
            return new CountingProtocolResponseReader(super.newPeekingReader(), this.apiChannel, this.getStartedResponses(), this.getCompletedResponses());
        }

        public long getStartedResponses() {
            return this.startedResponses.get();
        }

        public long getCompletedResponses() {
            return this.completedResponses.get();
        }

        private void startResponse() {
            this.startedResponses.incrementAndGet();
        }

        private void completeResponse() {
            this.completedResponses.incrementAndGet();
        }
    }
}

