/*
 * Copyright (c) 2017 pCloud AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.pcloud.networking.client;

import com.pcloud.networking.client.internal.tls.DefaultHostnameVerifier;

import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

class ConnectionFactory {

    private SocketFactory socketFactory;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;

    ConnectionFactory() {
        this(SocketFactory.getDefault(),
                (SSLSocketFactory) SSLSocketFactory.getDefault(),
                DefaultHostnameVerifier.INSTANCE);
    }

    ConnectionFactory(HostnameVerifier hostnameVerifier) {
        this(SocketFactory.getDefault(),
                (SSLSocketFactory) SSLSocketFactory.getDefault(),
                hostnameVerifier);
    }

    ConnectionFactory(SocketFactory socketFactory,
                      SSLSocketFactory sslSocketFactory,
                      HostnameVerifier hostnameVerifier) {
        this.socketFactory = socketFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
    }

    RealConnection createConnection(Endpoint endpoint) {
        if (endpoint == null) {
            throw new AssertionError("Null endpoint argument.");
        }

        return new RealConnection(socketFactory,
                sslSocketFactory,
                hostnameVerifier,
                endpoint);
    }
}
