/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.Connection;
import com.pcloud.networking.client.Endpoint;
import com.pcloud.networking.client.RealConnection;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConnectionPool {
    private static final long DEFAULT_KEEP_ALIVE_TIME_MS = 60L;
    private static final long NANOS_TO_MILLIS_COEF = 1000000L;
    private static final int MAX_IDLE_CONN_COUNT = 5;
    private static final long MAX_KEEP_ALIVE_DURATION = 5L;
    private static final Executor CLEANUP_THREAD_EXECUTOR;
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private final Runnable cleanupRunnable = new Runnable(){

        @Override
        public void run() {
            long waitNanos;
            while ((waitNanos = ConnectionPool.this.cleanup(System.nanoTime())) != -1L) {
                if (waitNanos <= 0L) continue;
                long waitMillis = waitNanos / 1000000L;
                waitNanos -= waitMillis * 1000000L;
                try {
                    Thread.sleep(waitMillis, (int)waitNanos);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
    };
    private final Set<RealConnection> connections = new LinkedHashSet<RealConnection>();
    private boolean cleanupRunning;

    public ConnectionPool() {
        this(5, 5L, TimeUnit.MINUTES);
    }

    public ConnectionPool(int maxIdleConnections, long keepAliveDuration, TimeUnit timeUnit) {
        if (maxIdleConnections < 0) {
            throw new IllegalArgumentException("maxIdleConnections < 0: " + maxIdleConnections);
        }
        if (keepAliveDuration <= 0L) {
            throw new IllegalArgumentException("keepAliveDuration < 0:" + keepAliveDuration);
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("time unit is null.");
        }
        this.maxIdleConnections = maxIdleConnections;
        this.keepAliveDurationNs = timeUnit.toNanos(keepAliveDuration);
    }

    public int maxIdleConnections() {
        return this.maxIdleConnections;
    }

    public synchronized int connectionCount() {
        return this.connections.size();
    }

    synchronized RealConnection get(Endpoint endpoint) {
        Iterator<RealConnection> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            RealConnection connection = iterator.next();
            if (!connection.endpoint().equals(endpoint)) continue;
            iterator.remove();
            return connection;
        }
        return null;
    }

    synchronized void recycle(RealConnection connection) {
        if (!this.cleanupRunning) {
            this.cleanupRunning = true;
            CLEANUP_THREAD_EXECUTOR.execute(this.cleanupRunnable);
        }
        connection.setIdle(System.nanoTime());
        this.connections.add(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() {
        ArrayList<RealConnection> evictedConnections = new ArrayList<RealConnection>();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            Iterator<RealConnection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                RealConnection connection = iterator.next();
                evictedConnections.add(connection);
                iterator.remove();
            }
        }
        for (Connection connection : evictedConnections) {
            IOUtils.closeQuietly((Closeable)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long cleanup(long now) {
        RealConnection longestIdleConnection = null;
        long longestIdleDurationNs = Long.MIN_VALUE;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            int idleConnectionCount = this.connections.size();
            for (RealConnection connection : this.connections) {
                long idleDurationNs = now - connection.idleAtNanos();
                if (idleDurationNs <= longestIdleDurationNs) continue;
                longestIdleDurationNs = idleDurationNs;
                longestIdleConnection = connection;
            }
            if (longestIdleDurationNs < this.keepAliveDurationNs && idleConnectionCount <= this.maxIdleConnections) {
                if (idleConnectionCount > 0) {
                    return this.keepAliveDurationNs - longestIdleDurationNs;
                }
                this.cleanupRunning = false;
                return -1L;
            }
            this.connections.remove(longestIdleConnection);
        }
        IOUtils.closeQuietly(longestIdleConnection);
        return 0L;
    }

    static {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread result = new Thread(runnable, "PCloudAPI ConnectionPool");
                result.setDaemon(true);
                return result;
            }
        };
        CLEANUP_THREAD_EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }
}

