/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.Endpoint;
import com.pcloud.networking.client.EndpointProvider;
import com.pcloud.networking.client.RealConnection;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import okio.Buffer;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Sink;
import okio.Source;

class ErrorReportingConnection
extends RealConnection {
    private EndpointProvider endpointProvider;

    ErrorReportingConnection(SocketFactory socketFactory, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, Endpoint endpoint) {
        super(socketFactory, sslSocketFactory, hostnameVerifier, endpoint);
    }

    @Override
    void connect(int connectTimeout, TimeUnit timeUnit) throws IOException {
        try {
            super.connect(connectTimeout, timeUnit);
        }
        catch (IOException e) {
            EndpointProvider endpointProvider = this.endpointProvider();
            if (endpointProvider != null) {
                endpointProvider.endpointConnectionError(this.endpoint(), e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endpointProvider(EndpointProvider endpointProvider) {
        ErrorReportingConnection errorReportingConnection = this;
        synchronized (errorReportingConnection) {
            this.endpointProvider = endpointProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndpointProvider endpointProvider() {
        ErrorReportingConnection errorReportingConnection = this;
        synchronized (errorReportingConnection) {
            return this.endpointProvider;
        }
    }

    @Override
    protected Source createSource(Socket socket) throws IOException {
        Source source = super.createSource(socket);
        EndpointProvider endpointProvider = this.endpointProvider();
        if (endpointProvider != null) {
            return new ReportingSource(source, endpointProvider, this.endpoint());
        }
        return source;
    }

    @Override
    protected Sink createSink(Socket socket) throws IOException {
        Sink sink = super.createSink(socket);
        EndpointProvider endpointProvider = this.endpointProvider();
        if (endpointProvider != null) {
            return new ReportingSink(sink, endpointProvider, this.endpoint());
        }
        return sink;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    static class ReportingSink
    extends ForwardingSink {
        private final EndpointProvider endpointProvider;
        private final Endpoint endpoint;

        ReportingSink(Sink sink, EndpointProvider endpointProvider, Endpoint endpoint) {
            super(sink);
            this.endpointProvider = endpointProvider;
            this.endpoint = endpoint;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            try {
                super.write(source, byteCount);
            }
            catch (IOException e) {
                this.endpointProvider.endpointWriteError(this.endpoint, e);
                throw e;
            }
        }

        public void flush() throws IOException {
            try {
                super.flush();
            }
            catch (IOException e) {
                this.endpointProvider.endpointWriteError(this.endpoint, e);
                throw e;
            }
        }
    }

    static class ReportingSource
    extends ForwardingSource {
        private final EndpointProvider endpointProvider;
        private final Endpoint endpoint;

        ReportingSource(Source source, EndpointProvider endpointProvider, Endpoint endpoint) {
            super(source);
            this.endpointProvider = endpointProvider;
            this.endpoint = endpoint;
        }

        public long read(Buffer sink, long byteCount) throws IOException {
            try {
                return super.read(sink, byteCount);
            }
            catch (IOException e) {
                this.endpointProvider.endpointReadError(this.endpoint, e);
                throw e;
            }
        }
    }
}

