/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.ApiChannel;
import com.pcloud.networking.client.Call;
import com.pcloud.networking.client.ConnectionPool;
import com.pcloud.networking.client.ConnectionProvider;
import com.pcloud.networking.client.Endpoint;
import com.pcloud.networking.client.EndpointProvider;
import com.pcloud.networking.client.MultiCall;
import com.pcloud.networking.client.RealApiChannel;
import com.pcloud.networking.client.RealCall;
import com.pcloud.networking.client.RealMultiCall;
import com.pcloud.networking.client.Request;
import com.pcloud.networking.client.RequestInterceptor;
import com.pcloud.networking.client.internal.tls.DefaultHostnameVerifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class PCloudAPIClient {
    private static final long DEFAULT_KEEP_ALIVE_TIME = 60L;
    private static final int DEFAULT_CONNECT_TIMEOUT = 15;
    private static final int DEFAULT_READ_TIMEOUT = 30;
    private static final int DEFAULT_WRITE_TIMEOUT = 30;
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "PCloud API Client");
        }
    };
    private int connectTimeoutMs;
    private int writeTimeoutMs;
    private int readTimeoutMs;
    private final SocketFactory socketFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final List<RequestInterceptor> interceptors;
    private final ConnectionPool connectionPool;
    private final ConnectionProvider connectionProvider;
    private final EndpointProvider endpointProvider;
    private final ExecutorService callExecutor;

    private PCloudAPIClient(Builder builder) {
        this.connectTimeoutMs = builder.connectTimeoutMs;
        this.writeTimeoutMs = builder.writeTimeoutMs;
        this.readTimeoutMs = builder.readTimeoutMs;
        this.socketFactory = builder.socketFactory != null ? builder.socketFactory : SocketFactory.getDefault();
        this.sslSocketFactory = builder.sslSocketFactory != null ? builder.sslSocketFactory : (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.hostnameVerifier = builder.hostnameVerifier != null ? builder.hostnameVerifier : DefaultHostnameVerifier.INSTANCE;
        this.connectionPool = builder.connectionPool != null ? builder.connectionPool : new ConnectionPool();
        this.endpointProvider = builder.endpointProvider != null ? builder.endpointProvider : EndpointProvider.DEFAULT;
        this.connectionProvider = new ConnectionProvider(this.connectionPool, this.endpointProvider, this.socketFactory, this.sslSocketFactory, this.hostnameVerifier, this.connectTimeoutMs, this.readTimeoutMs, this.writeTimeoutMs, false);
        this.callExecutor = builder.callExecutor != null ? builder.callExecutor : new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), DEFAULT_THREAD_FACTORY);
        this.interceptors = Collections.unmodifiableList(new ArrayList<RequestInterceptor>(builder.interceptors));
    }

    public Call newCall(Request request) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null.");
        }
        return new RealCall(request, this.callExecutor, this.interceptors, this.connectionProvider);
    }

    public MultiCall newCall(Collection<Request> requests) {
        if (requests == null) {
            throw new IllegalArgumentException("Requests collection cannot be null.");
        }
        if (requests.isEmpty()) {
            throw new IllegalArgumentException("Requests collection is empty.");
        }
        for (Request request : requests) {
            if (request != null) continue;
            throw new IllegalArgumentException("Collection cannot contain null requests.");
        }
        return new RealMultiCall(new ArrayList<Request>(requests), this.callExecutor, this.interceptors, this.connectionProvider, null);
    }

    public MultiCall newCall(Collection<Request> requests, Endpoint endpoint) {
        if (requests == null) {
            throw new IllegalArgumentException("Requests collection cannot be null.");
        }
        if (requests.isEmpty()) {
            throw new IllegalArgumentException("Requests collection is empty.");
        }
        for (Request request : requests) {
            if (request != null) continue;
            throw new IllegalArgumentException("Collection cannot contain null requests.");
        }
        return new RealMultiCall(new ArrayList<Request>(requests), this.callExecutor, this.interceptors, this.connectionProvider, endpoint);
    }

    public ApiChannel newChannel() throws IOException {
        return new RealApiChannel(this.connectionProvider, this.endpointProvider.endpoint());
    }

    public ApiChannel newChannel(Endpoint endpoint) throws IOException {
        return new RealApiChannel(this.connectionProvider, endpoint);
    }

    public int connectTimeout() {
        return this.connectTimeoutMs;
    }

    public int writeTimeout() {
        return this.writeTimeoutMs;
    }

    public int readTimeout() {
        return this.readTimeoutMs;
    }

    public SocketFactory socketFactory() {
        return this.socketFactory;
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public ConnectionPool connectionPool() {
        return this.connectionPool;
    }

    public ExecutorService callExecutor() {
        return this.callExecutor;
    }

    public List<RequestInterceptor> interceptors() {
        return this.interceptors;
    }

    public EndpointProvider endpointProvider() {
        return this.endpointProvider;
    }

    public void shutdown() {
        this.callExecutor.shutdownNow();
        this.connectionPool.evictAll();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static Builder newClient() {
        return new Builder().setConnectTimeout(15, TimeUnit.SECONDS).setWriteTimeout(30, TimeUnit.SECONDS).setReadTimeout(30, TimeUnit.SECONDS);
    }

    public static class Builder {
        private int connectTimeoutMs;
        private int writeTimeoutMs;
        private int readTimeoutMs;
        private ConnectionPool connectionPool;
        private EndpointProvider endpointProvider;
        private SocketFactory socketFactory;
        private SSLSocketFactory sslSocketFactory;
        private HostnameVerifier hostnameVerifier;
        private ExecutorService callExecutor;
        List<RequestInterceptor> interceptors;

        private Builder(PCloudAPIClient cloudAPIClient) {
            this.connectTimeoutMs = cloudAPIClient.connectTimeoutMs;
            this.writeTimeoutMs = cloudAPIClient.writeTimeoutMs;
            this.readTimeoutMs = cloudAPIClient.readTimeoutMs;
            this.connectionPool = cloudAPIClient.connectionPool;
            this.endpointProvider = cloudAPIClient.endpointProvider;
            this.socketFactory = cloudAPIClient.socketFactory;
            this.sslSocketFactory = cloudAPIClient.sslSocketFactory;
            this.hostnameVerifier = cloudAPIClient.hostnameVerifier;
            this.callExecutor = cloudAPIClient.callExecutor;
            this.interceptors = new LinkedList<RequestInterceptor>(cloudAPIClient.interceptors);
        }

        private Builder() {
            this.interceptors = new LinkedList<RequestInterceptor>();
        }

        public Builder addInterceptor(RequestInterceptor interceptor) {
            if (interceptor == null) {
                throw new IllegalArgumentException("RequestInterceptor cannot be null.");
            }
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder addInterceptors(Collection<RequestInterceptor> interceptors) {
            if (interceptors == null) {
                throw new IllegalArgumentException("RequestInterceptor collection cannot be null.");
            }
            for (RequestInterceptor r : interceptors) {
                this.addInterceptor(r);
            }
            return this;
        }

        public Builder addInterceptorAtFront(RequestInterceptor interceptor) {
            if (interceptor == null) {
                throw new IllegalArgumentException("RequestInterceptor cannot be null.");
            }
            this.interceptors.add(0, interceptor);
            return this;
        }

        public Builder setConnectTimeout(int timeout, TimeUnit timeUnit) {
            this.connectTimeoutMs = Builder.convertTimeValue(timeout, timeUnit);
            return this;
        }

        public Builder setWriteTimeout(int timeout, TimeUnit timeUnit) {
            this.writeTimeoutMs = Builder.convertTimeValue(timeout, timeUnit);
            return this;
        }

        public Builder setReadTimeout(int timeout, TimeUnit timeUnit) {
            this.readTimeoutMs = Builder.convertTimeValue(timeout, timeUnit);
            return this;
        }

        public Builder connectionPool(ConnectionPool connectionPool) {
            if (connectionPool == null) {
                throw new IllegalArgumentException("ConnectionPool cannot be null.");
            }
            this.connectionPool = connectionPool;
            return this;
        }

        public Builder endpointProvider(EndpointProvider endpointProvider) {
            if (endpointProvider == null) {
                throw new IllegalArgumentException("EndpointProvider cannot be null.");
            }
            this.endpointProvider = endpointProvider;
            return this;
        }

        public Builder setSocketFactory(SocketFactory socketFactory) {
            if (socketFactory == null) {
                throw new IllegalArgumentException("SocketFactory cannot be null.");
            }
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            if (sslSocketFactory == null) {
                throw new IllegalArgumentException("SSLSocketFactory cannot be null.");
            }
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            if (hostnameVerifier == null) {
                throw new IllegalArgumentException("HostnameVerifier cannot be null.");
            }
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder callExecutor(ExecutorService executorService) {
            this.callExecutor = executorService;
            return this;
        }

        public PCloudAPIClient create() {
            return new PCloudAPIClient(this);
        }

        private static int convertTimeValue(long timeout, TimeUnit timeUnit) {
            if (timeout < 0L) {
                throw new IllegalArgumentException("timeout < 0");
            }
            if (timeUnit == null) {
                throw new NullPointerException("unit == null");
            }
            long millis = timeUnit.toMillis(timeout);
            if (millis > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Value too large.");
            }
            if (millis == 0L && timeout > 0L) {
                throw new IllegalArgumentException("Value too small.");
            }
            return (int)millis;
        }
    }
}

