/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.Request;
import com.pcloud.networking.client.ResponseBody;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;

public class Response
implements Closeable {
    private ResponseBody responseBody;
    private Request request;

    public static Builder create() {
        return new Builder();
    }

    private Response(Builder builder) {
        this.responseBody = builder.responseBody;
        this.request = builder.request;
    }

    public Request request() {
        return this.request;
    }

    public ResponseBody responseBody() {
        return this.responseBody;
    }

    public String toString() {
        return this.responseBody.toString();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.responseBody);
    }

    public static class Builder {
        private ResponseBody responseBody;
        private Request request;

        private Builder() {
        }

        public Builder request(Request request) {
            if (request == null) {
                throw new IllegalArgumentException("Request argument cannot be null.");
            }
            this.request = request;
            return this;
        }

        public Builder responseBody(ResponseBody responseBody) {
            if (responseBody == null) {
                throw new IllegalArgumentException("ResponseBody argument cannot be null.");
            }
            this.responseBody = responseBody;
            return this;
        }

        public Response build() {
            if (this.request == null) {
                throw new IllegalArgumentException("Request argument cannot be null.");
            }
            if (this.responseBody == null) {
                throw new IllegalArgumentException("ResponseBody argument cannot be null.");
            }
            return new Response(this);
        }
    }
}

