/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;

public class ResponseData
implements Closeable {
    private final BufferedSource source;
    private final long contentLength;

    ResponseData(BufferedSource source, long contentLength) {
        this.source = source;
        this.contentLength = contentLength;
    }

    public InputStream byteStream() {
        return this.source().inputStream();
    }

    public BufferedSource source() {
        return this.source;
    }

    public ByteString byteString() throws IOException {
        try {
            ByteString byteString = this.source.readByteString(this.contentLength);
            return byteString;
        }
        finally {
            this.close();
        }
    }

    public byte[] bytes() throws IOException {
        try {
            byte[] byArray = this.source.readByteArray(this.contentLength);
            return byArray;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.source);
    }

    public long contentLength() {
        return this.contentLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        try {
            sink.writeAll((Source)this.source);
        }
        finally {
            this.close();
        }
    }
}

